#!/usr/bin/env bash
# Set up IDM_TOKEN env var
# https://wiki.yandex-team.ru/intranet/idm/api/public/#authentication
# make your app, then request oauth token with url
# Request it here (PoC) https://oauth.yandex-team.ru/authorize?response_type=token&client_id={{id}}
#
# Docs about required logfeller grants: https://wiki.yandex-team.ru/logfeller/aclandquotas/
BASE_PATH="//home/logfeller/logs"
LOGS="paysys-trust-stable-yb-trust-notify paysys-trust-stable-yb-trust-notify-ng paysys-trust-stable-yb-trust-notify-xg"
RESPONSIBLES="librarian fedusia"
READ_USERS="robot-rambo"
# To get group id go to idm, open request form,
# enter yt hahn, read access, enter needed group/abc
# service, and id will be in url
READ_GROUP_IDS="81405 88467 29489"

TEST=true

idm_request() {
    local who=$1
    local who_id=$2
    local idm_path=$3
    local yt_path=$4
    echo
    echo " .. Requesting (test=${TEST}) ${idm_path} for ${who} ${who_id} on ${yt_path}"
    echo
    curl -H "Authorization: OAuth $IDM_TOKEN" -H "Content-Type: application/json" -d '
        {
            "'${who}'": "'${who_id}'",
            "path": "'${idm_path}'",
            "system": "yt-cluster-hahn",
            "simulate": '${TEST}',
            "fields_data": {"path": "'${yt_path}'"}
        }
    ' "https://idm-api.yandex-team.ru/api/v1/rolerequests/"
    echo
    echo " .. Done"
    echo
}

if [ -z "$IDM_TOKEN" ]; then
    echo " !! Empty IDM_TOKEN"
    exit 1
fi

if [ "$1" == "test=false" ]; then
    TEST=false
    shift
fi

case "$1" in
    help)
        echo "There are two stages in idm requests:"
        echo " 1. Creating write access for logfeller, removing @yandex access for logs, setting up read_approver's for future stage"
        echo "  $ bash idm.sh test=false stage=1"
        echo " 2. Creating read access for specified users and groups"
        echo "  $ bash idm.sh test=false stage=2"
        echo "If you want to test, omit test=false"
    ;;
    stage=1)
        echo
        echo " !! At first stage, we must request write access for logfeller, otherwise it won't be able to write logs"
        echo " !! Also we requesting read_approver grant so paysys-admin will be able to approve read requests"
        echo

        for log in $LOGS; do
            # Request Logfeller Read/Write access
            idm_request group 49870 /write/ "${BASE_PATH}/${log}"
            # Responsibles for logs
            for responsible in $RESPONSIBLES; do
                idm_request user "${responsible}" /read_approver/ "${BASE_PATH}/${log}"
                # idm_request user "${responsible}" /responsible/ "${BASE_PATH}/${log}"
            done
        done

        echo
        echo " !! After that we will need to wait for approval of these roles before requesting disabling acl and read roles"
        echo
    ;;
    stage=2)
        echo " !! Requesting acl inheritance removal and read roles"
        echo

        for log in $LOGS; do
            idm_request user robot-yt-idm /disable_acl_inheritance/ "${BASE_PATH}/${log}"

            for user in $READ_USERS; do
                idm_request user "${user}" /read/ "${BASE_PATH}/${log}"
            done

            for group in $READ_GROUP_IDS; do
                idm_request group "${group}" /read/ "${BASE_PATH}/${log}"
            done
        done

        echo " !! Done!"
        echo
    ;;
    *)
        echo "$1 bad argument"
        exit 255;
    ;;
esac

