#!/usr/bin/env bash
APP=mdh
# Service slug on abc
ABC=mdh
# topic will be created for each of components in all envs
COMPONENTS=(backend frontend)
# PAIRS of tvm_id/env will be iterated at the same time
ENVS=(stable testing)
TVM_IDS=(2021850 2021852)
LOGFELLER_TVM_ID=2001185
ACCOUNT=mdh
YT_CLUSTER=hahn
RESPONSIBLES=iandreyev,fedusia

#LogFeller options
LF_30MIN_RETENTION="7d"
LF_1D_RETENTION="1095d"

LB_EXECUTABLE="./logbroker "
LB_ARGS=""

DRY_RUN=true

while [ -n "$1" ]; do
echo $1
case "$1" in
-apply)
  DRY_RUN=false
  ;;
-force-yes)
  LB_ARGS="${LB_ARGS} --yes"
  ;;
*)
  echo "$1 bad argument"
  exit 255;
  ;;
esac
shift
done


if [[ $DRY_RUN == true ]]; then
   LB_ARGS="${LB_ARGS} --dry-run"
   echo "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
   echo "!!!!!!!                                                 !!!!!!!"
   echo "!!!!!!! Running in dry mode, no changes will be applied !!!!!!!"
   echo "!!!!!!!                                                 !!!!!!!"
   echo "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
fi


logbroker() {
  ${LB_EXECUTABLE} -s logbroker "$@"
}

echo "Create new account ${ACCOUNT} if not exists"
logbroker schema create account ${LB_ARGS} ${ACCOUNT} --abc-service ${ABC} --responsible ${RESPONSIBLES}
logbroker schema create directory ${LB_ARGS} ${ACCOUNT}/${APP} --abc ${ABC}
echo ""

for i in ${!ENVS[*]}; do
    ENV=${ENVS[$i]}
    TVM_ID=${TVM_IDS[$i]}
    echo "Creates topics for $ENV environment"
    logbroker schema create directory ${LB_ARGS} "${ACCOUNT}/${APP}/${ENV}" --abc ${ABC}

    for COMPONENT in ${COMPONENTS[*]}; do
       logbroker schema create topic ${LB_ARGS} -p 2 --allow-unauthenticated-write false --allow-unauthenticated-read false --responsible ${RESPONSIBLES} "$ACCOUNT/$APP/$ENV/$COMPONENT"
       logbroker permissions grant ${LB_ARGS} --path "$ACCOUNT/$APP/$ENV/$COMPONENT" --subject "${TVM_ID}@tvm" --permissions WriteTopic
       logbroker permissions grant ${LB_ARGS} --path "$ACCOUNT/$APP/$ENV/$COMPONENT" --subject "${LOGFELLER_TVM_ID}@tvm" --permissions ReadTopic
    done
    echo ""
done
echo ""


lf_topic() {
    TOPIC="$ACCOUNT/$APP/$1/$2"
    TOPIC_NAME="${ACCOUNT}-${APP}-${1}-${2}"
    cat <<EOF
    "${TOPIC_NAME}": {
        "name": "${TOPIC_NAME}",
        "#aspects": "@common_project:log_presets:${YT_CLUSTER}:build_low_priority",
        "cluster_name": "${YT_CLUSTER}",
        "streams": [
            "@streams:${YT_CLUSTER}:${TOPIC}"
        ],
        "periods": [
            "30min",
            "1d"
        ],
        "lifetimes": {
            "30min": "${LF_30MIN_RETENTION}",
            "1d": "${LF_1D_RETENTION}"
        },
        "ultrafast_options": {
            "forward_logbroker_metadata": true,
            "tables_lifetime": "7d",
            "sensitive_data_scanning_policy": "no_scan"
        },
        "build_options": "@log_options:build:common",
        "rebuild_options": "@log_options:rebuild:common",
        "archive_options": "@log_options:archive:common",
        "infer_yt_schema": true
    },
EOF
}

lf_stream() {
    TOPIC="$ACCOUNT/$APP/$1/$2"
    cat <<EOF
    "${TOPIC}": { 
        "topic_path": "${TOPIC}",
        "logbroker": "@stream_options:logbroker:common_${YT_CLUSTER}",
        "indexing_options": "@stream_options:indexing:schema_common_noscan",
        "parsing_options": {
            "chunk_splitter_name": "line-break",
            "parser_name": "cat-parser",
            "formatter_name": "native"
        },
        "lifetimes": "@stream_options:lifetimes:common",
        "priority": "low"
    },
EOF
}

echo "Create new PR into logfeller configs:"
echo "Add this lines into /arcadia/logfeller/configs/logs/common_${YT_CLUSTER}_logs.json"
for ENV in ${ENVS[*]}; do
    for COMPONENT in ${COMPONENTS[*]}; do
     	lf_topic "${ENV}" "${COMPONENT}"
    done
done
echo ""


echo "Add this lines into /arcadia/logfeller/configs/logs/common_${YT_CLUSTER}_streams.json"
for ENV in ${ENVS[*]}; do
    for COMPONENT in ${COMPONENTS[*]}; do
     	lf_stream "${ENV}" "${COMPONENT}"
    done
done
echo ""
echo ""

echo "Execute after PR will be merged"
echo ""
for i in ${!ENVS[*]}; do
    ENV=${ENVS[$i]}
    TVM_ID=${TVM_IDS[$i]}
    for COMPONENT in ${COMPONENTS[*]}; do
       echo "logbroker -s logbroker yt-delivery add -t $ACCOUNT/$APP/$ENV/$COMPONENT --yt ${YT_CLUSTER} -d"
    done
done
