#!/usr/bin/env bash

# REMOVE : before "yc" to run commands

# https://oauth.yandex-team.ru/authorize?response_type=token&client_id=23db397a10ae4fbcb1a7ab5896dc00f6
# to get ABC_TOKEN

# https://oauth.yandex-team.ru/authorize?response_type=token&client_id=987d584798e7409cacf3e039d5c94523
# to get STAFF_TOKEN

ABC_URL="https://abc-back.yandex-team.ru/api/v4/services/members/?format=json&is_robot=false&page_size=1000&role__scope__slug=db_management&service__slug=strust&fields=person.login"
USERS=$(curl -s -H "Authorization: OAuth $ABC_TOKEN" "$ABC_URL" | jq -r .results[].person.login | sort -u | tr '\n' ' ')
USERS_DELIM=$(echo $USERS | tr ' ' '|')
USERS_TO_IGNORE="trust_|tis754"
CLUSTERS=$(yc managed-postgresql cluster list | grep -E 'prod|shard' | grep -vE "test|sentry" | awk '{print $4}' | tr '\n' ' ')
echo "Users: $USERS"
echo "Clusters: $CLUSTERS"
echo

function grant_mdb_admin_to_users() {
    echo "Beginning setting user grants"
    for cluster in $CLUSTERS;
    do

        for user in $USERS;
        do
            yc_result=$(yc managed-postgresql user get "$user" --cluster-name "$cluster" --format json | jq .grants)
            if echo $yc_result | grep -qv mdb_admin;
            then
                echo "$user $cluster"
            fi
        done
    done | while read user cluster; do
        echo "We will grant $user on $cluster mdb_admin,reader"
        : yc managed-postgresql user update "$user" --grants mdb_admin,reader --cluster-name "${cluster}"
    done
}

function remove_users_without_grants() {
    echo "Beginning users removal"
    for cluster in $CLUSTERS;
    do
        yc_result=$(yc managed-postgresql user list --cluster-name "$cluster" --format json | jq -r .[].name)
        echo $yc_result | tr ' ' '\n' | grep -vE "$USERS_DELIM" | grep -vE "$USERS_TO_IGNORE" | while read user;
        do
            yc_result=$(yc managed-postgresql user get "$user" --cluster-name "$cluster" --format json | jq .grants)
            if echo $yc_result | grep -qvE "reader|writer|mdb_admin";
            then
                echo "$user $cluster"
            fi
        done
    done | while read user cluster; do
        STAFF_URL="https://staff-api.yandex-team.ru/v3/persons?_pretty=1&_one=1&login=${user}&_fields=official.is_dismissed"
        staff_result=$(curl -s -H "Authorization: OAuth $STAFF_TOKEN" "$STAFF_URL" | jq -r .official.is_dismissed)
        case $staff_result in
            "true")
                echo "We will automatically remove $user from $cluster (he is dismissed)"
            ;;
            "false")
                echo "User to remove $user $cluster (unknown status)"
            ;;
            *)
                echo "something wrong"
                exit 1
            ;;
        esac
        : yc managed-postgresql user delete "$user" --cluster-name "$cluster"
    done
}

case $1 in
    "grant")
        grant_mdb_admin_to_users
    ;;
    "remove_without_grants")
        remove_users_without_grants
    ;;
esac




