from paysys.sre.tools.deploy.validator.lib.clients.helpers import parse_json
import requests


class _AbcClientIpl():
    base_url = 'https://abc-back.yandex-team.ru/api/v4'

    def __init__(self, token):
        self.token = token

    def __get_oauth_header(self):
        return {"Authorization": "OAuth {}".format(self.token)}

    @parse_json
    def get_service_by_id(self, id):
        url = self.base_url + "/services/{0}/?fields=slug".format(id)
        return requests.get(url, headers=self.__get_oauth_header()).text


class AbcClient():
    def __init__(self, token):
        self.impl = _AbcClientIpl(token)

    def get_service_by_id(self, id):
        return self.impl.get_service_by_id(id)
