from functools import wraps
import yaml
import json


def parse_yaml(fn):
    @wraps(fn)
    def closure(*args, **kwargs):
        return yaml.safe_load(fn(*args, **kwargs))

    return closure


def parse_json(fn):
    @wraps(fn)
    def closure(*args, **kwargs):
        return json.loads(fn(*args, **kwargs))

    return closure
