import subprocess
import logging
from functools import wraps

logger = logging.getLogger()


def execute(fn):
    @wraps(fn)
    def closure(*args, **kwargs):
        p = subprocess.Popen(fn(*args, **kwargs),  stdout=subprocess.PIPE, stderr=subprocess.PIPE)
        stdout, stderr = p.communicate()
        rcode = p.returncode
        if rcode != 0:
            logger.debug("Shell: Command finished with not null return code: {0}\nSTDOUT: {1}\nSTDERR: {2}".format(rcode, stdout, stderr))
        return rcode, stdout, stderr
    return closure


def is_rcode_null(fn):

    def closure(*args, **kwargs):
        rcode, stdout, stderr = fn(*args, **kwargs)
        return rcode == 0

    return closure


def stdout(fn):
    @wraps(fn)
    def closure(*args, **kwargs):
        rcode, stdout, stderr = fn(*args, **kwargs)
        if rcode != 0:
            logger.warn("Shell: Command finished with not null return code: {0}\nSTDOUT: {1}\nSTDERR: {2}".format(rcode, stdout, stderr))
        return stdout

    return closure
