from paysys.sre.tools.monitorings.lib.checks.base import unreachable as unreachable_base
from paysys.sre.tools.monitorings.lib.util.helpers import check, merge, ttl, gen_children


def yb_ar_bunker_token(hosts):
    """
    Здесь мы задаем проверку, которая будет получать данные по сырым событиям по сервису `yb-ar-bunker-token`.
    Хосты группируются по названию CGROUP из кондуктора, для на это:
      - ps-back:
        - все продакшен хосты баланса
      - ps-front-test, ps-back-test:
       - все тестовые хосты баланса
    """
    name = 'yb-ar-bunker-token'
    return check(
        name,
        ttl(7200, 3600),
        gen_children(
            hosts,
            [name],
        ),
    )


def unreachable(hosts):
    """
    Здесь мы задаем проверку, которая будет проверять доступность хостов.
    Сейчас хосты аналогичны `yb_ar_bunker_token`.
    Если потребуется добавить дополнительные хосты в проверку - то потребуется отдельно генерировать greed-*,
      отдельно для deploy.
    """
    name = 'UNREACHABLE'
    return merge(
        unreachable_base,
        check(
            name,
            gen_children(
                hosts,
                [name],
            ),
        ),
    )
