from paysys.sre.tools.monitorings.lib.checks.base import common
from paysys.sre.tools.monitorings.lib.checks.doc import doc
from paysys.sre.tools.monitorings.lib.util.helpers import merge, flaps, ttl
from paysys.sre.tools.monitorings.lib.notifications import Notifications, FIN_TOOLS_TELEGRAM_GROUP, FIN_TOOLS_ESCALATION_USERS


IRON_WOMAN_DELAY = 1200
notifications_object = Notifications()
notifications_object.set_telegram(FIN_TOOLS_TELEGRAM_GROUP + ['Balance_apikeys_monitorings'])
notifications_object.set_iron_woman(logins=FIN_TOOLS_ESCALATION_USERS, delay=IRON_WOMAN_DELAY)


def checks_common(children):
    return merge(
        common(children),
        {
            'syslog-alive': doc('https://wiki.yandex-team.ru/dljaadminov/paysys/ps/syslog-ng/'),
            'push-client': merge(flaps(900, 3600), ttl(3780, 300)),
        },
    )
