from paysys.sre.tools.monitorings.lib.checks.base import disk_ssd, cpu_usage
from paysys.sre.tools.monitorings.lib.checks.doc import doc
from paysys.sre.tools.monitorings.lib.checks.graphite import graphite_check
import paysys.sre.tools.monitorings.lib.checks.active.http as http
import paysys.sre.tools.monitorings.lib.checks.services as services
from paysys.sre.tools.monitorings.lib.util.helpers import merge, update_checks
import paysys.sre.tools.monitorings.configs.apikeys.base as base


def get_checks(children, graphite_prefix):
    return merge(
        base.checks_common(children),
        services.nginx,
        http.http_bundle('apikeys.yandex.net', port=8666),
        http.https_bundle('apikeys.yandex.net', port=8668),
        disk_ssd(children),
        cpu_usage(children),
        update_checks(
            merge(
                graphite_check(
                    'tasker_missing_contractor_tasks',
                    '{}.tasker_missing_contractor_tasks_graph'.format(graphite_prefix),
                    0,
                    0,
                    '-20min'
                ),
                graphite_check(
                    'tasker_missing_limit_checker_tasks',
                    '{}.tasker_missing_limit_checker_tasks_graph'.format(graphite_prefix),
                    0,
                    0,
                    '-20min'
                ),
                graphite_check(
                    'tasker_missing_tarifficator_tasks',
                    '{}.tasker_missing_tarifficator_tasks_graph'.format(graphite_prefix),
                    0,
                    0,
                    '-20min'
                ),
                graphite_check(
                    'tasker_errors',
                    '{}.tasker_errors_graph'.format(graphite_prefix),
                    1000,
                    100,
                    '-20min'
                ),
                graphite_check(
                    'timeline_slots_available',
                    "{}.timeline_slots_available_graph".format(graphite_prefix),
                    47,
                    47,
                    '-20min',
                    less=True
                ),
            ),
            doc(
                title='Documentation',
                url='https://wiki.yandex-team.ru/tech/developer/Monitoring/'
            )
        )
    )
