from paysys.sre.tools.monitorings.lib.checks.active.http import http
from paysys.sre.tools.monitorings.lib.checks.awacs import l7_monitoring
from paysys.sre.tools.monitorings.lib.checks.base import unreachable
from paysys.sre.tools.monitorings.lib.util.helpers import merge, check, gen_children_deploy, ttl, flaps, make_aggregated_check


def get_checks(children, balancers):
    return merge(
        l7_monitoring(balancers),
        check('certs'),
        check('unispace'),
        check('pushclient_check', ttl(900, 300), flaps(180, 900)),
        make_aggregated_check(check=unreachable, percent=40),
        http('backend', 8080, ok_codes=[200, 301, 302], crit=0, headers={'Host': 'localhost'}),
        check('backend', gen_children_deploy(children, 'backend')),
        *[
            check(x, gen_children_deploy(children, x))
            for x in [
                'UNREACHABLE',
                'pushclient_check',
                'certs',
                'unispace'
            ]
        ]
    )
