import paysys.sre.tools.monitorings.lib.checks.mongo as mongo
from paysys.sre.tools.monitorings.lib.util.helpers import merge, update_checks, gen_unreach


def get_checks(children, cluster, shards, unreach_host):
    return merge(
        update_checks(
            update_checks(
                mongo.mongo_with_single_shardgroup(children, cluster, shards, host=unreach_host),
                {'aggregator_kwargs': {}}
            ),
            gen_unreach(['{0}:UNREACHABLE'.format(unreach_host)], 'skip'),
        )
    )
