from paysys.sre.tools.monitorings.lib.util.helpers import merge, ttl
from paysys.sre.tools.monitorings.configs.apikeys.base import notifications_object


notifications = {
    'default': notifications_object.iron_woman_and_telegram,
    'by_service': {
        'UNREACHABLE': notifications_object.iron_woman_and_sms_abc_and_telegram,
        'unispace': notifications_object.iron_woman_and_sms_abc_and_telegram,
        'iptruler': notifications_object.iron_woman_and_sms_abc_and_telegram,
        'nginx-alive': notifications_object.iron_woman_and_sms_abc_and_telegram,
        'nginx_errors': notifications_object.iron_woman_and_telegram_graphite,
        'nginx_errors_disaster': notifications_object.iron_woman_and_sms_abc_and_telegram,
        'nginx_499_percent': notifications_object.iron_woman_and_telegram_graphite,
        'nginx_95_prc': notifications_object.telegram_graphite,
        'nginx_99_prc': notifications_object.telegram_graphite,
        'graphite-client': notifications_object.noop,
        'bmc': notifications_object.iron_woman_daytime_and_telegram,
        'clock': notifications_object.iron_woman_daytime_and_telegram,
        'cpu': notifications_object.iron_woman_daytime_and_telegram,
        'cpu_usage': notifications_object.telegram,
        'disk': notifications_object.iron_woman_daytime_and_telegram,
        'ecc': notifications_object.iron_woman_daytime_and_telegram,
        'gpu': notifications_object.iron_woman_daytime_and_telegram,
        'link': notifications_object.iron_woman_and_sms_abc_and_telegram,
        'mem': notifications_object.iron_woman_daytime_and_telegram,
        'paysys_archiver': notifications_object.iron_woman_daytime_and_telegram,
        'syslog-alive': notifications_object.noop,
        'disk-util': notifications_object.noop,
        'disk-wait': notifications_object.noop,
        'certs': notifications_object.noop,
        'watchdog': {},
        'tasker_errors': notifications_object.telegram_graphite,
        'tasker_missing_limit_checker_tasks': notifications_object.telegram_graphite,
        'tasker_missing_tarifficator_tasks': notifications_object.telegram_graphite,
        'tasker_missing_contractor_tasks': notifications_object.telegram_graphite,
        'timeline_slots_available': notifications_object.telegram_graphite,
        'mongod_cpu_usage': notifications_object.telegram,
        'mongos_cpu_usage': notifications_object.telegram,
    },
    'by_tag': {
        'https_main': notifications_object.iron_woman_and_sms_abc_and_telegram,
        'a_mark_billing-userapikeys-l7': notifications_object.iron_woman_and_sms_abc_and_telegram,
    },
}

defaults = merge(
    ttl(620, 60),
    {'namespace': 'apikeys'},
)

CONFIGS = [
    'apikeys',
    'apikeys_l7',
    'apikeys_mdb_mongod',
    'apikeys_mdb_mongos',
    'balance_userapikeys_l7',
    'delete_later_apikeys_mongobckp',
    'delete_later_tech_mongo',
    'delete_later_tech_mongobckp',
    'tech',
    'disaster_alert',
]
