from paysys.sre.tools.monitorings.lib.checks.base import pkgver
from paysys.sre.tools.monitorings.lib.checks.nginx_bundles import nginx_combaine_bundle_windowed
from paysys.sre.tools.monitorings.lib.checks.graphite import graphite_check
from paysys.sre.tools.monitorings.lib.checks.doc import doc
from paysys.sre.tools.monitorings.lib.checks.nginx_bundles import CombaineSettings, CombainePercentSettings
from paysys.sre.tools.monitorings.lib.checks.services import keepalived, sox_agent
from paysys.sre.tools.monitorings.lib.util.helpers import merge
from paysys.sre.tools.monitorings.configs.apikeys.base import apikeys


host = 'apikeys.stable'
children = ['apikeys-prod']


graphite_prefix = 'paysys.prod.combaine'
graphite_postfix = 'nginx-apikeys.apikeys'
percentiles = {'95_prc': 0.2, '99_prc': 0.8}


def checks():
    return merge(
        apikeys.get_checks(children, 'five_min.apikeys.prod'),
        sox_agent,
        keepalived,
        pkgver,
        nginx_combaine_bundle_windowed(
            children,
            'prod',
            'apikeys_prod.nginx-apikeys.apikeys',
            CombaineSettings(crit_by_host=3.0 / 60, warn_by_host=3.0 / 60),
            None,  # CombaineSettings(crit_by_host=crit_499_by_host, warn_by_host=warn_499_by_host),
            None,  # CombaineWindowSettings(immediate_multiplier=5.0, window_multiplier=5.0, window='5min'),
            None,  # combaine_499_window_settings override to None
            None,  # combaine_error_percent_settings  override to None aka nginx_error_percent
            CombainePercentSettings(8.0, 2),  # override 499 percentile for backward compatibility
            prefix=None
        ),
        *[
            merge(
                graphite_check(
                    name='nginx_{}'.format(check_name),
                    metric='{}.apikeys_prod.{}.not_ping_or_redirect_timings.{}'.format(
                        graphite_prefix, graphite_postfix, check_name
                    ),
                    url='https://gr-mg.yandex-team.ru',
                    warn=crit,
                    crit=crit
                ),
                {
                    'nginx_{}'.format(check_name): doc(
                        title='Dashboard',
                        url='https://grafana.yandex-team.ru/d/2mdnE0Kmz/apikeys?viewPanel=16&orgId=1&refresh=5s'
                    )
                }
            ) for check_name, crit in percentiles.items()
        ]
    )
