from paysys.sre.tools.monitorings.configs.apikeys.base import balance_userapikeys_l7, notifications_object
from paysys.sre.tools.monitorings.lib.util.helpers import update_checks, merge

defaults = {'namespace': 'userapikeys'}

host = 'billing-userapikeys-l7.stable'
children = ['billing-userapikeys@stage=billing-userapikeys-prod-stage']
hostname = 'balance-userapikeys-l7.paysys.yandex.net'

l7_balancers = [
    {
        'namespace': hostname,
        'datacenters': ['man', 'sas', 'vla'],
        'host': hostname,
        'http_ports': [80],
        'https_ports': [443],
        'services': [
            'rtc_balancer_balance-userapikeys-l7_paysys_yandex_net_man',
            'rtc_balancer_balance-userapikeys-l7_paysys_yandex_net_sas',
            'rtc_balancer_balance-userapikeys-l7_paysys_yandex_net_vla',
        ],
        'checks': {
            'cpu_usage': {'warn': 60, 'crit': 80},
            'cpu_wait': {'warn': 0.5, 'crit': 1},
            'codes_5xx': {'warn': 0.5, 'crit': 1},
            'attempts_backend_errors': {'warn': 1, 'crit': 2},
        },
    },
]


def checks():
    cs = balance_userapikeys_l7.get_checks(
        children,
        l7_balancers
    )
    cs = update_checks(cs, notifications_object.iron_woman_and_sms_abc_and_telegram)
    if 'certs' in cs.keys():
        cs['certs']['notifications'] = []
        cs['certs'] = merge(cs['certs'], notifications_object.telegram)
    return cs
