from paysys.sre.tools.monitorings.configs.apikeys.base import delete_later_tech_mongo as tech, notifications_object
from paysys.sre.tools.monitorings.lib.util.helpers import merge, update_checks, gen_children, gen_unreach, flaps


host = "tech-mongo.delete-later.stable"
children = ['tech-prod']


def checks():
    return update_checks(
        merge(
            tech.get_checks(children, 'tech-prod', 1, 'tech.stable'),
            {'celery': merge(
                gen_children(
                    children,
                    [
                        'celeryd-study-api-alive',
                        'celeryd-tech-api-alive',
                        'celeryd-tech-api-com-alive',
                    ]
                ),
                gen_unreach(['tech.stable:UNREACHABLE'], 'skip'),
                flaps(300, 1800, 0)
            )},
        ),
        notifications_object.noop,
    )
