from paysys.sre.tools.monitorings.lib.checks import graphite
from paysys.sre.tools.monitorings.lib.util.helpers import merge


host = 'apikeys'
children = ['apikeys-prod']


def checks():
    result = merge(
        graphite.graphite_check(
            'nginx_errors_disaster',
            'paysys.prod.combaine.apikeys_prod.nginx-apikeys.apikeys.errors',
            crit=1500,
            warn=500,
            window='-20min',
            url='https://gr-mg.yandex-team.ru'
        )
    )
    result['nginx_errors_disaster']['tags'] = [
        'warden_alert_create_spi',
        'is_disaster',
        'disaster',
        'marty',
        'createspi',
    ]
    return result
