from paysys.sre.tools.monitorings.configs.apikeys.base import tech
from paysys.sre.tools.monitorings.lib.util.helpers import merge
from paysys.sre.tools.monitorings.lib.checks.base import pkgver, cpu_usage
from paysys.sre.tools.monitorings.lib.checks.nginx_bundles import nginx_combaine_bundle
from paysys.sre.tools.monitorings.lib.checks.active.http import https_bundle


host = "tech.stable"
children = ['tech-prod']

https_tech_settings = {
    'developer-admin': {
        'headers': {
            'Host': 'admin-developer.tech.yandex-team.ru',
        },
        'port': 443,
    },
    'developer': {
        'headers': {
            'Host': 'developer.tech.yandex.ru',
        },
        'port': 443,
    },
}


def gen_https_checks(https_settings):
    tech_checks = {}

    for check_name, check in https_settings.items():
        tech_checks = merge(
            tech_checks, https_bundle(
                check_name,
                port=check['port'],
                headers=check['headers']
            )
        )

    return tech_checks


def checks():
    https_tech_checks = gen_https_checks(https_tech_settings)

    return merge(
        pkgver,
        tech.get_checks(children),
        https_tech_checks,
        nginx_combaine_bundle(
            conductor_children=children,
            combaine_env='prod',
            combaine_path='tech_prod.nginx-tech.tech',
        ),
        cpu_usage(children)
    )
