from paysys.sre.tools.monitorings.lib.checks import services, base, doc
from paysys.sre.tools.monitorings.lib.util.helpers import gen_children, check, merge


def get_checks(children):
    rac_modif = services.oracle_rac.copy()
    exclude_db_checks = ['matview-monitor', 'mvlogmove', 'matview-refresh', 'oracle-status', 'user-objects-in-sys',
                         'ro-services', 'fk-indexing', 'shared_pool_free_mem', 'ps_ts_info', 'ps_segment_info',
                         'psdbstat', 'db-file_locations']

    database_result = services.oracle_database.copy()
    [database_result.pop(exclude) for exclude in exclude_db_checks]

    rac_modif.pop('iscsi-ips')
    rac_modif.pop('oracle-patches')

    return merge(base.common_fin_fin(children),
                 database_result,
                 rac_modif,
                 services.pipeline_sender,
                 check('runbackup_rman', merge(gen_children(children, 'runbackup_rman'), doc.doc_link('common.oracle'))))
