from paysys.sre.tools.monitorings.lib.util.helpers import gen_children, check, merge, flaps, ttl, unreach_skip
from paysys.sre.tools.monitorings.configs.backup.base import database
from paysys.sre.tools.monitorings.lib.util.aggregators import logic_or, downtime_skip

host = "market.backup"  # VIRT HOST
children = ['paysys_market_backup']  # CGROUP

exclude_db_checks = ['rm-logs', 'link_utilization']

exclude_rac_checks = ['iscsi-params']

database_result = database.get_checks(children).copy()
[database_result.pop(exclude) for exclude in exclude_db_checks]
[database_result.pop(exclude) for exclude in exclude_rac_checks]


def checks():
    result = merge(
        database_result,
        check('netconsole_reciever', merge(flaps(300, 900), ttl(620, 300), gen_children(children, 'netconsole_reciever'),
                                           logic_or, unreach_skip, downtime_skip)),
    )
    return result
