from paysys.sre.tools.monitorings.lib.util.helpers import gen_children, check, merge, gen_unreach_by_service, flaps, ttl, unreach_skip
from paysys.sre.tools.monitorings.configs.backup.base import database
from paysys.sre.tools.monitorings.lib.checks import doc
from paysys.sre.tools.monitorings.lib.util.aggregators import logic_or, downtime_skip

host = "oebs.backup"  # VIRT HOST
children = ['paysys_backup']  # CGROUP
children_sox = ['paysys_backup_sox']

exclude_db_checks = ['rm-logs', 'runbackup_rman', 'net_services', 'oracle_memory_usage']

database_result = database.get_checks(children).copy()
[database_result.pop(exclude) for exclude in exclude_db_checks]


def checks():
    database_result.update(check('runbackup_rman', merge(gen_children(children_sox, 'runbackup_rman'), doc.doc_link('common.oracle'))))

    result = merge(
        database_result,
        check('uptime', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'uptime'),
                              logic_or, unreach_skip, downtime_skip)),
        check('grid-up', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'grid-up'),
                               logic_or, unreach_skip, downtime_skip)),
        check('database-up', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'database-up'),
                                   logic_or, unreach_skip, downtime_skip)),
        check('unispace5', merge(flaps(300, 900), ttl(620, 300), gen_children(children, 'unispace5'),
                                 logic_or, unreach_skip, downtime_skip)),
        check('netconsole_reciever', merge(flaps(300, 900), ttl(620, 300), gen_children(children_sox, 'netconsole_reciever'),
                                           logic_or, unreach_skip, downtime_skip)),
    )
    result = gen_unreach_by_service(result)
    return result
