from paysys.sre.tools.monitorings.lib.util.helpers import merge, ttl, flaps, check, unreach_skip, gen_children, gen_unreach_by_service
from paysys.sre.tools.monitorings.lib.checks import base, services
from paysys.sre.tools.monitorings.lib.util.aggregators import logic_and, downtime_skip, logic_or
from paysys.sre.tools.monitorings.configs.balance.base import database

host = "balance.dev.db"  # VIRT HOST
children = ['balance-rdbms-dev']  # CGROUP

exclude_db_checks = [
    'oracle-status', 'ro-services', 'shared_pool_free_mem', 'mvlogmove', 'psdbstat', 'ps_ts_info', 'ps_segment_info',
    'user-objects-in-sys', 'db-file_locations', 'net_services',
    'matview-refresh', 'matview-monitor', 'fk-indexing'
]

exclude_rac_checks = ['oracle-patches']

database_global = services.oracle_database.copy()
database_project = database.get_checks(children)

database_result = merge(database_global, database_project)
[database_result.pop(exclude) for exclude in exclude_db_checks]

rac_result = services.oracle_rac.copy()
[rac_result.pop(exclude) for exclude in exclude_rac_checks]


def checks():
    result = merge(base.common_fin_fin(children),
                   rac_result,
                   database_result,
                   check('oracle-status-balance1', merge(ttl(3700, 300), logic_and, unreach_skip, downtime_skip)),
                   check('oracle-status-meta1', merge(ttl(3700, 300), logic_and, unreach_skip, downtime_skip)),
                   services.pipeline_sender,
                   check('uptime', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'uptime'),
                                         logic_or, unreach_skip, downtime_skip)),
                   check('grid-up', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'grid-up'),
                                          logic_or, unreach_skip, downtime_skip)),
                   check('database-up', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'database-up'),
                                              logic_or, unreach_skip, downtime_skip)),
                   )
    result = gen_unreach_by_service(result)
    result.pop('link_utilization')
    result.pop('mount')
    return result
