from paysys.sre.tools.monitorings.lib.util.helpers import merge, ttl, check, unreach_skip, flaps, gen_children, gen_unreach_by_service
from paysys.sre.tools.monitorings.lib.checks import base, services, graphite
from paysys.sre.tools.monitorings.lib.util.aggregators import logic_and, downtime_skip, logic_or
from paysys.sre.tools.monitorings.configs.balance.base import database

host = "balance.dbaas.db"  # VIRT HOST
children = ['ps-dbaas-rdbms-vla', 'ps-dbaas-rdbms-sas']  # CGROUP

exclude_db_checks = [
    'oracle-status', 'ro-services', 'shared_pool_free_mem', 'mvlogmove', 'psdbstat', 'ps_ts_info', 'ps_segment_info',
    'user-objects-in-sys', 'db-file_locations', 'net_services', 'db-parameters', 'oracle_memory_usage',
    'matview-refresh', 'matview-monitor', 'fk-indexing'
]

exclude_rac_checks = ['oracle-patches']

database_global = services.oracle_database.copy()
database_project = database.get_checks(children)

database_result = merge(database_global, database_project)
[database_result.pop(exclude) for exclude in exclude_db_checks]

rac_result = services.oracle_rac.copy()
[rac_result.pop(exclude) for exclude in exclude_rac_checks]

graph_data = 'minSeries(transformNull(asPercent(removeAboveValue(averageSeries(one_min.greed-ts[1-9][h_v_e_f]_paysys_yandex_net.balance_yandex_ru.db_ping),1)),0)'
graph_data = graph_data + ',transformNull(asPercent(removeAboveValue(averageSeries(one_min.greed-pt[1-9][h_v_e_f]_paysys_yandex_net.balance_yandex_ru.db_ping),1)),0))'
graphite_slanonprod = graphite.graphite_check('balancedb_slanonprod',
                                              graph_data,
                                              warn_expr='metric < 98', crit_expr='metric < 90')
graphite_slanonprod['balancedb_slanonprod'].pop('refresh_time')
graphite_slanonprod['balancedb_slanonprod'].update(merge(ttl(300, 60), flaps(300, 1200)))


def checks():
    result = merge(base.common_fin_fin(children),
                   graphite_slanonprod,
                   rac_result,
                   database_result,
                   check('oracle-status-metaptd1', merge(ttl(180, 60), logic_and, unreach_skip, downtime_skip)),
                   check('oracle-status-metaptd2', merge(ttl(180, 60), logic_and, unreach_skip, downtime_skip)),
                   check('oracle-status-balaptd1', merge(ttl(180, 60), logic_and, unreach_skip, downtime_skip)),
                   check('oracle-status-balaptd2', merge(ttl(180, 60), logic_and, unreach_skip, downtime_skip)),
                   check('oracle-status-mvdb', merge(ttl(180, 60), logic_and, unreach_skip, downtime_skip)),
                   check('oracle-status-metatst1', merge(ttl(180, 60), logic_and, unreach_skip, downtime_skip)),
                   check('oracle-status-metatst2', merge(ttl(180, 60), logic_and, unreach_skip, downtime_skip)),
                   check('oracle-status-balatst1', merge(ttl(180, 60), logic_and, unreach_skip, downtime_skip)),
                   check('oracle-status-balatst2', merge(ttl(180, 60), logic_and, unreach_skip, downtime_skip)),
                   services.pipeline_sender,
                   check('uptime', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'uptime'),
                                         logic_or, unreach_skip, downtime_skip)),
                   check('grid-up', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'grid-up'),
                                          logic_or, unreach_skip, downtime_skip)),
                   check('database-up', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'database-up'),
                                              logic_or, unreach_skip, downtime_skip)),
                   check('oracle-balance-patches', merge(ttl(5400, 3600), logic_or, unreach_skip, downtime_skip)),
                   )
    result = gen_unreach_by_service(result)
    result.pop('link_utilization')
    result.pop('mount')
    return result
