from paysys.sre.tools.monitorings.lib.util.helpers import check, gen_children, merge, ttl
from paysys.sre.tools.monitorings.lib.checks import base, services
from paysys.sre.tools.monitorings.configs.balance.base import database

host = "balance.psnode"  # VIRT HOST
children = ['ps-nodedb']  # CGROUP

exclude_db_checks = ['oracle-status']

database_global = services.oracle_database.copy()
database_project = database.get_checks(children)

database_result = merge(database_global, database_project)
[database_result.pop(exclude) for exclude in exclude_db_checks]


def checks():
    return merge(base.common_fin_fin(children),
                 services.oracle_rac,
                 database_result,
                 check('oracle-status-balance1',
                       gen_children(['ps-node06h.yandex.ru'], 'oracle-status-balance1', 'HOST'), ttl(3700, 300)),
                 check('oracle-status-balance2',
                       gen_children(['ps-node07h.yandex.ru'], 'oracle-status-balance2', 'HOST'), ttl(3700, 300)),
                 check('oracle-status-mvdb',
                       gen_children(['ps-node07h.yandex.ru'], 'oracle-status-mvdb', 'HOST'), ttl(3700, 300)),
                 services.mailq,
                 services.pipeline_sender,
                 )
