from paysys.sre.tools.monitorings.lib.util.helpers import check, merge, ttl, unreach_skip, flaps, gen_children, gen_unreach_by_service
from paysys.sre.tools.monitorings.lib.checks import base, services
from paysys.sre.tools.monitorings.lib.util.aggregators import logic_and, logic_or, downtime_skip
from paysys.sre.tools.monitorings.configs.balance.base import database

host = "balance.load.db"  # VIRT HOST
children = ['balance-rdbms-load', 'meta-rdbms-load', 'balance-load-standbys']  # CGROUP

exclude_db_checks = [
    'oracle-status', 'shared_pool_free_mem', 'rm-logs', 'user-objects-in-sys', 'ro-services',
    'ps_ts_info', 'ps_segment_info',
    'matview-refresh', 'matview-monitor', 'fk-indexing'
]

exclude_rac_checks = ['oracle-patches']

database_global = services.oracle_database.copy()
database_project = database.get_checks(children)

database_result = merge(database_global, database_project)
[database_result.pop(exclude) for exclude in exclude_db_checks]

rac_result = services.oracle_rac.copy()
[rac_result.pop(exclude) for exclude in exclude_rac_checks]


def checks():
    result = merge(base.common_fin_fin(children),
                   rac_result,
                   database_result,
                   check('oracle-status-balance1', merge(ttl(3700, 300), logic_and, unreach_skip, downtime_skip)),
                   services.mailq,
                   services.pipeline_sender,
                   check('uptime', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'uptime'),
                                         logic_or, unreach_skip, downtime_skip)),
                   check('grid-up', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'grid-up'),
                                          logic_or, unreach_skip, downtime_skip)),
                   check('database-up', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'database-up'),
                                              logic_or, unreach_skip, downtime_skip)),
                   )
    result = gen_unreach_by_service(result)
    result.pop('link_utilization')
    result.pop('watchdog')
    result.pop('mount')
    return result
