from paysys.sre.tools.monitorings.lib.checks import base
from paysys.sre.tools.monitorings.lib.util.helpers import check, merge, ttl, unreach_skip, flaps, gen_children, gen_unreach_by_service
from paysys.sre.tools.monitorings.lib.util.aggregators import logic_or, downtime_skip

host = "balance.load.target"  # VIRT HOST
children = ['balance-load-standbys']  # CGROUP


def checks():
    result = merge(base.common_fin_fin(children),
                   check('uptime', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'uptime'),
                                         logic_or, unreach_skip, downtime_skip)),
                   )
    result = gen_unreach_by_service(result)
    result.pop('link_utilization')
    result.pop('mount')
    return result
