from paysys.sre.tools.monitorings.lib.util.helpers import merge, ttl, check, unreach_skip, gen_children, flaps, gen_unreach_by_service
from paysys.sre.tools.monitorings.lib.checks import base, services, graphite
from paysys.sre.tools.monitorings.lib.util.aggregators import logic_and, logic_or, downtime_skip
from paysys.sre.tools.monitorings.configs.balance.base import database
from paysys.sre.tools.monitorings.lib.checks.doc import doc_link

host = "balance.stable.db"  # VIRT HOST
children = ['balance-rdbms']  # CGROUP
children_key_dbf = ['key-db1f.paysys.yandex.net', 'key-db2f.paysys.yandex.net']
children_key_dbv = ['key-db1v.paysys.yandex.net', 'key-db2v.paysys.yandex.net']
children_key_dbh = ['key-db1h.paysys.yandex.net', 'key-db2h.paysys.yandex.net']
children_all = children_key_dbf+children_key_dbv+children_key_dbh

exclude_db_checks = [
    'oracle-status', 'shared_pool_free_mem',
    'matview-refresh', 'matview-monitor', 'fk-indexing'
]
exclude_rac_checks = ['oracle-patches']

database_global = services.oracle_database.copy()
database_project = database.get_checks(children)

database_result = merge(database_global, database_project)
[database_result.pop(exclude) for exclude in exclude_db_checks]

rac_result = services.oracle_rac.copy()
[rac_result.pop(exclude) for exclude in exclude_rac_checks]

graphite_highload = graphite.graphite_check('balancedb_highload',
                                            'movingAverage(maxSeries(one_min.{key-db[12],idb[123456]}[fvh]_{paysys_yandex,yandex}_{net,ru}.{balancecdb[12],ICDB[123456]}.Database_Time_Per_Sec),20)',
                                            warn_expr='metric > 10000', crit_expr='metric > 25000')
graphite_highload['balancedb_highload'].pop('refresh_time')
graphite_highload['balancedb_highload'].update(merge(ttl(300, 60), flaps(300, 1200)))

graphite_diskwait = graphite.graphite_check('balancedb_diskwait',
                                                      'highestMax(movingAverage(one_min.key-db[12][fvh]_{paysys_yandex,yandex}_{net,ru}.diskstat_wait_sd*.wait,20),1)',
                                                      warn_expr='metric > 20', crit_expr='metric > 100')
graphite_diskwait['balancedb_diskwait'].pop('refresh_time')
graphite_diskwait['balancedb_diskwait'].update(merge(ttl(300, 60), flaps(300, 1800)))


def checks():
    result = merge(base.common_fin_fin(children),
                   graphite_highload,
                   graphite_diskwait,
                   check('farsync-state', merge(flaps(300, 600), ttl(600, 60), logic_or, unreach_skip, downtime_skip)),
                   database_result,
                   rac_result,
                   check('oracle-status-balance1', merge(ttl(180, 60), logic_and, unreach_skip, downtime_skip)),
                   check('oracle-status-balance2', merge(ttl(180, 60), logic_and, unreach_skip, downtime_skip)),
                   services.mailq,
                   services.pipeline_sender,
                   services.audit,
                   check('oracle-status-mvdb-dbf', merge(ttl(350, 60), gen_children(children_key_dbf, 'oracle-status-mvdb', 'HOST'), logic_and, unreach_skip, downtime_skip)),
                   check('oracle-status-mvdb-dbv', merge(ttl(350, 60), gen_children(children_key_dbv, 'oracle-status-mvdb', 'HOST'), logic_and, unreach_skip, downtime_skip)),
                   check('oracle-status-mvdb-dbh', merge(ttl(350, 60), gen_children(children_key_dbh, 'oracle-status-mvdb', 'HOST'), logic_and, unreach_skip, downtime_skip)),
                   check('oracle-status-mvdb', merge(flaps(300, 7200), gen_children(host, ['oracle-status-mvdb-dbf',
                                                                                           'oracle-status-mvdb-dbv',
                                                                                           'oracle-status-mvdb-dbh'], 'HOST'),
                                                     doc_link('balance.paysys'))),
                   check('uptime', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'uptime'),
                                         logic_or, unreach_skip, downtime_skip)),
                   check('grid-up', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'grid-up'),
                                          logic_or, unreach_skip, downtime_skip)),
                   check('database-up', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'database-up'),
                                              logic_or, unreach_skip, downtime_skip)),
                   check('oracle-balance-patches', merge(ttl(5400, 3600), logic_or, unreach_skip, downtime_skip)),
                   check('unispace5', merge(flaps(300, 900), ttl(620, 300), logic_or, unreach_skip, downtime_skip)),
                   check('s3backup-balance', merge(flaps(300, 900), ttl(3700, 1800), logic_or, unreach_skip, downtime_skip)),
                   )
    result.pop('mount')
    result = gen_unreach_by_service(result)
    return result
