from paysys.sre.tools.monitorings.lib.util.helpers import merge, ttl, check, unreach_skip, flaps, gen_children
from paysys.sre.tools.monitorings.lib.util.aggregators import logic_or, downtime_skip
from paysys.sre.tools.monitorings.lib.checks import base, services

host = "balance.stable.farsync"  # VIRT HOST
children = ['balance-farsync']  # CGROUP


def checks():
    result = merge(base.common_fin_fin(children),
                   services.pipeline_sender,
                   check('farsync-state', merge(flaps(300, 600), ttl(600, 60), logic_or, unreach_skip, downtime_skip)),
                   check('rm-logs', merge(ttl(3700, 300), logic_or, unreach_skip, downtime_skip)),
                   check('rm-traces', merge(ttl(620, 300), logic_or, unreach_skip, downtime_skip)),
                   check('unispace5', merge(flaps(300, 900), ttl(620, 300), gen_children(children, 'unispace5'))),
                   )
    result.pop('mount')
    return result
