from paysys.sre.tools.monitorings.lib.checks.base import common
from paysys.sre.tools.monitorings.lib.checks.doc import doc
from paysys.sre.tools.monitorings.lib.util.helpers import merge, flaps, ttl
from paysys.sre.tools.monitorings.lib.notifications import (
    Notifications,
    status_change,
    DEFAULT_TELEGRAM_DELAY,
    DEFAULT_IRON_WOMAN_DELAY,
)

GREEN_TELEGRAM_GROUP = ["Balance_Monitorings_Sandbox"]
YELLOW_TELEGRAM_GROUP = ["Balance_Monitorings"]
MNCLOSE_TELEGRAM_GROUP = ["Balance_mnclose_monitorings"]

NOTIFIED_STATUSES_TELEGRAM = [
    status_change("OK", "CRIT"),
    status_change("WARN", "CRIT"),
    status_change("CRIT", "OK"),
]


def duty_escalation(
    *first_notify  # type: str
):
    return list(first_notify) + [
        "@svc_balance:balance_release",
        "@svc_balance:duty-teamlead",
        "dskut",
    ]


def duty_notification_object(
    telegram_logins,  # type: list[str]
    abc_duty,  # type: list[str]
    call_logins,  # type: Iterable[str]
    iron_woman_delay_sec=DEFAULT_IRON_WOMAN_DELAY,  # type: int
    telegram_statuses=NOTIFIED_STATUSES_TELEGRAM,  # type: Iterable[str] | Iterable[dict[str, str], ...]
    telegram_delay_sec=DEFAULT_TELEGRAM_DELAY,  # type: int
):  # type: (...) -> Notifications
    notification_object = Notifications()
    notification_object.set_telegram(
        group=telegram_logins,
        statuses=telegram_statuses,
        delay=telegram_delay_sec,
    )
    notification_object.set_abc_duty(abc_duty)
    notification_object.set_iron_woman(call_logins, delay=iron_woman_delay_sec)

    return notification_object


devops_notifications_object = duty_notification_object(
    telegram_logins=YELLOW_TELEGRAM_GROUP,
    abc_duty=["@svc_balance:devops"],
    call_logins=duty_escalation("@svc_balance:devops"),
    iron_woman_delay_sec=20 * 60,
)

devops_disaster_notifications_object = duty_notification_object(
    telegram_logins=YELLOW_TELEGRAM_GROUP,
    abc_duty=["@svc_balance:devops"],
    call_logins=duty_escalation("@svc_balance:devops"),
    iron_woman_delay_sec=5 * 60,
)

yt_notifications_object = Notifications()
yt_notifications_object.set_telegram(
    ['balance-dcs', 'balance_log_tariff_monitorings'],
    statuses=["WARN", "CRIT", "OK"],
)

core_duty_notifications_object = duty_notification_object(
    telegram_logins=YELLOW_TELEGRAM_GROUP,
    abc_duty=["@svc_billing-core:billing-core-duty"],
    call_logins=duty_escalation("@svc_billing-core:billing-core-duty"),
    iron_woman_delay_sec=5 * 60,
)

partner_duty_notifications_object = duty_notification_object(
    telegram_logins=YELLOW_TELEGRAM_GROUP,
    abc_duty=["@svc_partners_team:billing_partners"],
    call_logins=duty_escalation("@svc_partners_team:billing_partners"),
    iron_woman_delay_sec=5 * 60,
)

kpi_notifications_object = (
    Notifications()
        .set_telegram(group=YELLOW_TELEGRAM_GROUP, statuses=NOTIFIED_STATUSES_TELEGRAM)
        .set_startrek(queue="BALANCEDUTY", components=["balance-monitoring"], priority="critical")
)

green_telegram = (
    Notifications()
        .set_telegram(group=GREEN_TELEGRAM_GROUP, statuses=NOTIFIED_STATUSES_TELEGRAM)
        .telegram
)

yellow_telegram = (
    Notifications()
        .set_telegram(group=YELLOW_TELEGRAM_GROUP, statuses=NOTIFIED_STATUSES_TELEGRAM)
        .telegram
)

paysup_notifications = (
    Notifications()
        .set_startrek(queue='PAYSUP', components=["balance-monitoring"], priority='normal')
)

mnclose_notifications = (
    Notifications()
        .set_telegram(group=MNCLOSE_TELEGRAM_GROUP, statuses=NOTIFIED_STATUSES_TELEGRAM)
        .set_startrek(queue="MNCLOSE", priority="critical")
        .startrek_and_telegram
)


def checks_common(children):
    return merge(
        common(children),
        {
            "syslog-alive": doc("https://wiki.yandex-team.ru/dljaadminov/paysys/ps/syslog-ng/"),
            "push-client": merge(flaps(900, 3600), ttl(3780, 300)),
        },
    )
