import paysys.sre.tools.monitorings.configs.paysys.base as base
import paysys.sre.tools.monitorings.lib.checks.services as services
from paysys.sre.tools.monitorings.lib.util.helpers import merge, gen_children_from_tuples, check


def get_checks(children):
    return merge(
        base.checks_common(children),
        services.nginx,
        services.yandex_passport_tvmtool,
        services.haproxy,
        services.solomon_agent
    )


def get_front_checks(children):
    x = get_checks(children)
    x.pop('yandex-passport-tvmtool')
    x.pop('haproxy')
    x.pop('solomon-agent')
    return x


xscript_socket = check('xscript-socket')
xscript_exception = check('xscript-exception')


def zookeeper(children_tuples):
    return merge(
        services.zookeeper,
        {'zookeeper': gen_children_from_tuples(children_tuples)}
    )


acl = check('ACL')
