from paysys.sre.tools.monitorings.lib.util.helpers import solomon_check, solomon_equal_selector
from paysys.sre.tools.monitorings.lib.util.solomon import solomon_expression_custom
from paysys.sre.tools.monitorings.lib.util.solomon_blocks import (
    OutputMixin,
    ProgramMixin,
    QueueAlertBlock,
    compose_program,
)


def check(cluster, queue_name, alert_size, notification):
    class ExportSelector(OutputMixin, ProgramMixin):
        @property
        def output_names(self):  # type: () -> set[str]
            return {"failed_sum"}

        def program(self):  # type: () -> str
            query = solomon_equal_selector(
                cluster=cluster,
                service='queue-processor',
                host='cluster',
                sensor='export.status',
                queue=queue_name.upper(),
                status='fail'
            )

            return '\n'.join(
                [
                    'let data = series_sum({query});'.format(query=query),
                    'let failed_sum = sum(data);'
                ]
            )

    selector = ExportSelector()
    alert_block = QueueAlertBlock(
        alert_size,
        queue_size=selector.failed_sum,
    )

    solomon_project = "balance"
    common_annotation = {
        "description": "Sum of failed objects in queue: {{expression.failed_sum}}",
    }

    expr = solomon_expression_custom(
        project_id=solomon_project,
        program_str=compose_program(selector, alert_block),
        annotations=common_annotation,
        resolved_empty_policy="RESOLVED_EMPTY_OK",
        no_points_policy="NO_POINTS_OK",
    )

    name = "{queue_name}-failed_{size}".format(queue_name=queue_name, size=alert_size)

    solomon_alert = solomon_check(
        name,
        expr,
        notification,
        {"aggregator_kwargs": None},
    )

    return solomon_alert
