import juggler_sdk

from paysys.sre.tools.monitorings.lib.util.helpers import (
    solomon_equal_selector,
    solomon_check,
)
from paysys.sre.tools.monitorings.lib.util.solomon_blocks import (
    UpperThresholdAlertBlock,
    AggregatedSelector,
    compose_program,
)
from paysys.sre.tools.monitorings.lib.util.solomon import (
    solomon_expression_custom,
    create_solomon_alert_id,
)

SOLOMON_PROJECT = "balance"


class Checks(object):

    alert_prefix = "log_tariff_"

    def __init__(
        self,
        host,  # type: str
        cluster,  # type: str
    ):
        self.host = host
        self.cluster = cluster

    def delay(
        self,
        folder_alias,  # type: str
        folder,  # type: str
        limit_sec,  # type: int
        notification,
    ):
        alert_name = self.alert_prefix + "{0}_delay".format(folder_alias)
        delay_selector = AggregatedSelector(
            var_name='delay',
            selector=solomon_equal_selector(
                project="balance",
                cluster=self.cluster,
                service="yt_log_tariff",
                host="*",
                sensor="last_table_creation_time",
                folder=folder
            ),
            aggregation_func='max',
        )
        alert_block = UpperThresholdAlertBlock(
            alarm_limit=limit_sec,
            decision_value=delay_selector.aggregated_var_name,
        )

        expr = solomon_expression_custom(
            project_id=SOLOMON_PROJECT,
            program_str=compose_program(delay_selector, alert_block),
            window_secs=10 * 60,
            group_by_labels=['host'],
            annotations={
                "description": "delay on {{{{labels.host}}}} is {{{{expression.{delay_var}}}}}".format(
                    delay_var=delay_selector.aggregated_var_name,
                )
            },
            juggler_children={
                "replace": True,
                "children": [
                    juggler_sdk.Child(
                        create_solomon_alert_id(self.host, alert_name),
                        "all",
                        "all",
                        "MONITORING_MULTIALERT",
                    ),
                ],
            },
        )
        return solomon_check(
            alert_name,
            expr,
            notification,
            {"aggregator_kwargs": {}},
        )
