from paysys.sre.tools.monitorings.lib.util.helpers import solomon_check, merge, flaps
from paysys.sre.tools.monitorings.lib.util.solomon import solomon_expression_custom
from paysys.sre.tools.monitorings.lib.util.solomon_blocks import (
    OutputMixin,
    ProgramMixin,
    QueueAlertBlock,
    compose_program,
)


def check(alias, name, alert_size, notification):
    class ExportNGSelector(OutputMixin, ProgramMixin):
        @property
        def output_names(self):  # type: () -> set[str]
            return {"failed_sum"}

        def program(self):  # type: () -> str
            query = (
                '{project="trust", '
                'cluster="greed-prod", service="trust_brother", '
                'host="greedaggr_prod", name="%s"}'
            ) % name

            return "let failed_sum = trunc(sum({query}));".format(query=query)

    selector = ExportNGSelector()
    alert_block = QueueAlertBlock(
        alert_size,
        queue_size=selector.failed_sum,
    )

    solomon_project = "balance"
    common_annotation = {
        "description": "Sum of failed objects in queue: {{expression.failed_sum}}",
    }

    expr = solomon_expression_custom(
        project_id=solomon_project,
        program_str=compose_program(selector, alert_block),
        annotations=common_annotation,
    )

    name = "{alias}-failed_{size}".format(alias=alias, size=alert_size)

    solomon_alert = solomon_check(
        name,
        expr,
        notification,
        {"aggregator_kwargs": None},
    )

    return merge(
        {name: flaps(360, 600)},
        solomon_alert,
    )
