from paysys.sre.tools.monitorings.lib.util.helpers import solomon_check, solomon_by_status_annotation, solomon_equal_selector
from paysys.sre.tools.monitorings.lib.util.solomon_blocks import OutputMixin, ProgramMixin, UpperThresholdAlertBlock, \
    compose_program, LowerThresholdAlertBlock
from paysys.sre.tools.monitorings.lib.util.solomon import solomon_expression_custom


solomon_project = "balance"


class IdleAverageSelector(OutputMixin, ProgramMixin):
    def __init__(self, cluster, window):
        self.window = window
        self.cluster = cluster

    def program(self):
        workers_idle = solomon_equal_selector(
            project=solomon_project,
            service='notifier',
            sensor='notifier.workers_idle',
            cluster=self.cluster,
            host='cluster'
        )
        workers_busy = solomon_equal_selector(
            project=solomon_project,
            service='notifier',
            sensor='notifier.workers_busy',
            cluster=self.cluster,
            host='cluster'
        )

        return "\n".join(
            [
                'let idle_average = moving_avg({idle} / ({idle} + {busy}), {window});'.format(
                    idle=workers_idle,
                    busy=workers_busy,
                    window=self.window
                ),
                'let idle_average_value = last(idle_average);'
            ]
        )

    @property
    def output_names(self):
        return {'idle_average_value', }


class Checks(object):
    def __init__(self, cluster):
        self.cluster = cluster

    def idle_workers(self):
        alarm_upper_limit = 0.5
        alarm_lower_limit = 0.15
        window_minutes = 30

        window = str(window_minutes) + 'm'
        selector = IdleAverageSelector(self.cluster, window=window)
        upper_threshold = UpperThresholdAlertBlock(
            alarm_limit=alarm_upper_limit,
            decision_value=selector.idle_average_value,
        )
        lower_threshold = LowerThresholdAlertBlock(
            alarm_limit=alarm_lower_limit,
            decision_value=selector.idle_average_value,
        )

        expr = solomon_expression_custom(
            project_id=solomon_project,
            program_str=compose_program(selector, upper_threshold, lower_threshold),
            annotations={
                "description": "\n".join([
                    "Average idle percent for {window} is {value}".format(
                        window=window,
                        value=selector.expr_idle_average_value
                    ),
                    solomon_by_status_annotation(
                        'Alarm',
                        'Idle percent is abnormally high (> {top}) or low (< {bottom})'.format(
                            top=alarm_upper_limit,
                            bottom=alarm_lower_limit,
                        )
                    )
                ]),
            },
            resolved_empty_policy="RESOLVED_EMPTY_ALARM",
            no_points_policy="NO_POINTS_ALARM",
            window_secs=window_minutes * 60,
        )

        return solomon_check(
            'workers_idle_percent',
            expr,
            {"aggregator_kwargs": {}},
        )
