from paysys.sre.tools.monitorings.lib.util.helpers import solomon_check, flaps
from paysys.sre.tools.monitorings.lib.util.solomon import solomon_timing_expression_monitoring


solomon_project = "balance"

annotations_timing = {
    "description":
        "{{#isOk}}Current value: {{expression.percentile}}{{/isOk}}\n"
        "{{#isAlarm}}Value {{expression.percentile}} is above critical threshold of {{expression.alarm_limit}}!{{/isAlarm}}\n"
        "{{#isWarn}}Value {{expression.percentile}} is above warn threshold of {{expression.warn_limit}}{{/isWarn}}",
}


def db_ping_time(cluster, service, database_id, warn_val, crit_val):
    selectors = {
        "cluster": cluster,
        "service": service,
        "sensor": "ping_time_ms_hgram",
        "method_name": database_id,
        "host": "cluster",
    }
    expr = solomon_timing_expression_monitoring(
        project_id=solomon_project,
        annotations=annotations_timing,
        selectors=selectors,
        percentile=80,
        warn_timing_threshold=warn_val,
        crit_timing_threshold=crit_val,
        description="%s: %s ping time" % (service, database_id)
    )
    return solomon_check(
        "db-ping-%s" % database_id,
        expr,
        {"aggregator_kwargs": None},
        flaps(stable=15, critical=30),
    )
