from paysys.sre.tools.monitorings.lib.util.helpers import solomon_check
from paysys.sre.tools.monitorings.lib.util.solomon import solomon_expression_custom
from paysys.sre.tools.monitorings.lib.util.solomon_blocks import (
    OutputMixin,
    ProgramMixin,
    QueueAlertBlock,
    compose_program,
)

solomon_project = "balance"

common_annotation = {
    "description": "Queue: {{expression.tpt_queue}}, rpm: {{expression.rpm}}",
}


def queue_size(cluster, alert_size, notification):
    class TPTSelector(OutputMixin, ProgramMixin):
        def __init__(self, metric_cluster):
            self.cluster = metric_cluster

        @property
        def output_names(self):  # type: () -> set[str]
            return {"tpt_queue"}

        def program(self):  # type: () -> str
            query = (
                '{{cluster="{cluster}", service="simple_brother", '
                'host="greedaggr_prod", export_type="THIRDPARTY_TRANS", '
                'metric_group="EXPORT_STATE_0", schema="BO", name="qty", '
                'metric_subgroup="CURRENT"}}'
            ).format(cluster=self.cluster)
            rpm_query = (
                '{{cluster="{cluster}", service="thirdparty-trans", '
                'host="cluster", sensor="export.status", '
                'classname="Payment", balance_service="All", '
                'queue="THIRDPARTY_TRANS", payment_method="All"}}'
            ).format(cluster=self.cluster)
            return "\n".join(
                [
                    "let tpt_queue = trunc(avg({query}));".format(query=query),
                    "let rpm = trunc(avg(series_sum({rpm_query}))) * 2;".format(
                        rpm_query=rpm_query
                    ),
                ]
            )

    selector = TPTSelector(cluster)
    alert_block = QueueAlertBlock(
        alert_size,
        queue_size=selector.tpt_queue,
    )

    expr = solomon_expression_custom(
        project_id=solomon_project,
        program_str=compose_program(selector, alert_block),
        annotations=common_annotation,
        window_secs=15 * 60,
    )

    return solomon_check(
        "thirdparty_trans_queue_size_{0}K".format(alert_size // 1000),
        expr,
        notification,
        {"aggregator_kwargs": None},
    )
