from paysys.sre.tools.monitorings.lib.util.helpers import merge, ttl
from paysys.sre.tools.monitorings.configs.balance_app.base import (
    devops_notifications_object,
    devops_disaster_notifications_object,
    yt_notifications_object,
    kpi_notifications_object,
    paysup_notifications
)

defaults = merge(
    ttl(620, 60),
    {'namespace': 'balance'},
)

notifications = {
    'default': devops_notifications_object.iron_woman_and_telegram,
    'by_service': {
        'UNREACHABLE': devops_notifications_object.iron_woman_and_sms_abc_and_telegram,
        'unispace': devops_notifications_object.iron_woman_and_sms_abc_and_telegram,
        'haproxy': devops_notifications_object.iron_woman_and_sms_abc_and_telegram,
        'iptruler': devops_notifications_object.iron_woman_and_sms_abc_and_telegram,
        'nginx-alive': devops_notifications_object.iron_woman_and_sms_abc_and_telegram,
        'nginx_errors': devops_notifications_object.iron_woman_and_sms_abc_and_telegram_graphite,
        'nginx_499': devops_notifications_object.iron_woman_and_sms_abc_and_telegram_graphite,
        'nginx_499_5min': devops_notifications_object.iron_woman_and_sms_abc_and_telegram_graphite,
        'nginx_499_percent': devops_notifications_object.iron_woman_and_sms_abc_and_telegram_graphite,
        'db-latency': devops_notifications_object.iron_woman_and_sms_abc_and_telegram_graphite,
        'oracle-conn': devops_notifications_object.iron_woman_and_sms_abc_and_telegram,
        # TODO: create disaster alert via maac as well
        '500_timeout_OR_harakiri_status_code': devops_disaster_notifications_object.iron_woman_and_telegram,
        '500_only_status_code': devops_disaster_notifications_object.iron_woman_and_telegram,
        'graphite-client': devops_notifications_object.noop,
        'mongo_statistics': {},
        'mongo_connect': devops_notifications_object.iron_woman_and_sms_abc_and_telegram,
        'mongo_rs_state': devops_notifications_object.iron_woman_and_sms_abc_and_telegram,
        'mongo_rs_lag': devops_notifications_object.iron_woman_and_sms_abc_and_telegram,
        'mysql_xtrabackup': devops_notifications_object.iron_woman_daytime,
        'mysqldump': devops_notifications_object.iron_woman_daytime,
        'ps-ping-alive': devops_notifications_object.iron_woman_and_sms_abc_and_telegram,
        'ps-closedc': devops_notifications_object.iron_woman_and_telegram,
        'yandex-passport-tvmtool': devops_notifications_object.iron_woman_and_sms_abc_and_telegram,
        'bmc': devops_notifications_object.iron_woman_daytime,
        'clock': devops_notifications_object.iron_woman_daytime,
        'cpu': devops_notifications_object.iron_woman_daytime,
        'disk': devops_notifications_object.iron_woman_daytime,
        'ecc': devops_notifications_object.iron_woman_daytime,
        'gpu': devops_notifications_object.iron_woman_daytime,
        'link': devops_notifications_object.iron_woman_and_sms_abc_and_telegram,
        'mem': devops_notifications_object.iron_woman_daytime,
        'paysys_archiver': devops_notifications_object.iron_woman_daytime,
        'syslog-alive': devops_notifications_object.noop,
        'disk-util': devops_notifications_object.noop,
        'disk-wait': devops_notifications_object.noop,
        'certs': devops_notifications_object.noop,
        'yb-ar-bunker-token': devops_notifications_object.iron_woman_daytime,
        'paysup-contracts-recency': paysup_notifications.startrek,
        'paysup-contracts-row-count': paysup_notifications.startrek,
        'watchdog': {},
        'check-certs': devops_notifications_object.iron_woman_daytime_and_sms_abc_and_telegram,
    },
    'by_tag': {
        'https_main': devops_notifications_object.iron_woman_and_sms_abc_and_telegram,
        'postgres': devops_notifications_object.iron_woman_and_sms_abc_and_telegram
    },
    'by_host': {
        'balance.ark': devops_notifications_object.iron_woman_daytime_and_telegram,
        'balance.logreceiver': devops_notifications_object.iron_woman_daytime_and_telegram,
        'balance.minsk-payments': devops_notifications_object.telegram,
        'balance.salt': devops_notifications_object.iron_woman_daytime_and_telegram,
        'balance.stable.notifier': devops_notifications_object.iron_woman_daytime_and_telegram,
        'balance.yt': yt_notifications_object.telegram_daytime,
        'balance.balance_kpi': kpi_notifications_object.startrek_and_telegram,
    }
}

CONFIGS = [
    "ark",
    "balance_back",
    "balance_front_ext",
    "balance_front_in",
    "balance_kpi",
    "balance_medium",
    "balance_oracle",
    "balance_product",
    "balance_snout_api",
    "balance_snout_proxy",
    "logreceiver",
    "minsk_payments",
    "nirvana",
    "notifier",
    "reactor",
    "salt",
    "yt",
    "yt_export",
    "monthclose_queue_status"
]
