from paysys.sre.tools.monitorings.configs.balance_app.base import balance
from paysys.sre.tools.monitorings.lib.checks.services import sox_agent
from paysys.sre.tools.monitorings.lib.util.helpers import check, gen_children, merge
from paysys.sre.tools.monitorings.lib.checks import services, graphite
from paysys.sre.tools.monitorings.lib.checks.base import pkgver, cpu_usage
from paysys.sre.tools.monitorings.lib.checks.mds import s3_mds
from paysys.sre.tools.monitorings.lib.checks.nginx_bundles import nginx_combaine_bundle
from paysys.sre.tools.monitorings.lib.checks.active.http import https_bundle, http_bundle

host = "balance.balance-back"

children = ['ps-back']


def db_latency():
    metric = 'movingAverage(maxSeries(one_min.greed[0-9]*.db_latency.key-db*),5)'
    return graphite.graphite_check(
        'db-latency',
        metric,
        30,
        30,
        '-20min'
    )


https_balance_settings = {
    'balance-callback-router': {
        'headers': {
            'Host': 'balance-callback-router.yandex.ru',
        },
        'port': 8026,
    },
    'balance-simpleapi': {
        'headers': {
            'Host': 'balance-simpleapi.yandex.ru',
        },
        'port': 8023,
    },
    'balance-mds-proxy': {
        'headers': None,
        'port': 8007,
    },
    'yb-dcs': {
        'headers': None,
        'port': 8024,
    },
    'balance-takeout': {
        'headers': {
            'Host': 'balance-takeout.paysys.yandex.net',
        },
        'port': 8013,
    }
}


def __gen_https_balance_checks(https_balance_settings):
    balance_checks = {}

    for check_name, check_data in https_balance_settings.items():
        balance_checks = merge(
            balance_checks,
            https_bundle(
                check_name,
                port=check_data['port'],
                headers=check_data['headers'],
                unreach=['UNREACHABLE', 'nginx-alive', 'oracle-conn'],
            ),
        )

    return balance_checks


def checks():
    return merge(
        balance.get_checks(children),
        balance.acl,
        check('balance-notifier', None),
        services.keepalived,
        services.memcached,
        check('omniNames-alive'),
        {'oracle-conn': merge(
            gen_children(
                children,
                ['oracle-conn-balance-write', 'oracle-conn-balance', 'oracle-conn-meta']
            ),
        )},
        db_latency(),
        check('yandex-upravlyator-oracle-proxy'),
        check('yb-yandex-passport-tvm-keyring'),
        services.zookeeper,
        {'zookeeper': gen_children(
            ['greed1f.yandex.ru', 'greed1e.yandex.ru', 'greed1v.paysys.yandex.net', 'greed1h.paysys.yandex.net'],
            'zookeeper',
            group_type='HOST'
        )},
        http_bundle('oebs-gate', port=8003, unreach=['UNREACHABLE', 'nginx-alive', 'oracle-conn']),
        http_bundle('balance-medium', port=8002, unreach=['UNREACHABLE', 'nginx-alive', 'oracle-conn']),
        __gen_https_balance_checks(https_balance_settings),
        nginx_combaine_bundle(
            conductor_children=children,
            combaine_env='prod',
            combaine_path='ps_back.nginx-balance-back.balance-back'
        ),
        services.ps_ping,
        services.ps_closedc,
        services.haproxy,
        pkgver,
        cpu_usage(children, warn=70, crit=90),
        sox_agent,
        s3_mds(
            mds_installation_type='production',
            alias='balance-s3-logs',
            service_id=1996,
            warn_threshold=65,
            crit_threshold=75,
        ),
    )
