from paysys.sre.tools.monitorings.configs.balance_app.base import balance
from paysys.sre.tools.monitorings.lib.checks.base import pkgver, cpu_usage
from paysys.sre.tools.monitorings.lib.checks.nginx_bundles import nginx_combaine_bundle_windowed
from paysys.sre.tools.monitorings.lib.checks.nginx_bundles import CombaineSettings, CombainePercentSettings
from paysys.sre.tools.monitorings.lib.checks.active.http import https_bundle
from paysys.sre.tools.monitorings.lib.checks.services import sox_agent
from paysys.sre.tools.monitorings.lib.util.helpers import merge
host = "balance.balance-front-int"

children = ['ps-front-in']


def checks():
    return merge(
        balance.get_front_checks(children),
        balance.xscript_socket,
        balance.xscript_exception,
        balance.acl,
        pkgver,
        https_bundle('admin.balance.yandex.ru', port=443),
        nginx_combaine_bundle_windowed(
            children,
            'prod',
            'ps_front_in.nginx-balance-front-int.balance-front-int',
            CombaineSettings(crit_by_host=3.0 / 60, warn_by_host=3.0 / 60),
            None,  # CombaineSettings(crit_by_host=crit_499_by_host, warn_by_host=warn_499_by_host),
            None,  # CombaineWindowSettings(immediate_multiplier=5.0, window_multiplier=5.0, window='5min'),
            None,  # combaine_499_window_settings override to None
            None,  # combaine_error_percent_settings  override to None aka nginx_error_percent
            CombainePercentSettings(3.0, 0.5),  # override 499 percentile for backward compatibility
            prefix=None
        ),
        cpu_usage(children),
        sox_agent
    )
