from paysys.sre.tools.monitorings.lib.util.helpers import merge, update_checks
from paysys.sre.tools.monitorings.lib.checks.graphite import graphite_check
from paysys.sre.tools.monitorings.lib.checks.doc import doc

host = "balance.balance_kpi"
children = []

kpi_graphite_pattern = "movingAverage(multiplySeries(scale(paysys.prod.combaine.{host_group}.*.{logs}.not_ping_or_redirect_timings.95_prc, 1000000), transformNull(scale(removeAboveValue(scale(paysys.prod.combaine.{host_group}.*.{logs}.not_ping_or_redirect, 60), 100), 0.000000000000000001), 1)), '20min'), '95_prc')"  # noqa

sla_int_important = graphite_check(
    name="SLA_int_important",
    metric=kpi_graphite_pattern.format(
        host_group="ps_front_in", logs="balance-front-int-real",
    ),
    crit=30000000,
    warn=30000000,
    url="https://gr-mg.yandex-team.ru",
)

sla_int_day = graphite_check(
    name="SLA_int_day",
    metric=kpi_graphite_pattern.format(
        host_group="ps_front_in", logs="balance-front-int-real",
    ),
    crit=10000000,
    warn=10000000,
    url="https://gr-mg.yandex-team.ru",
)

sla_ext_day = graphite_check(
    name="SLA_ext_day",
    metric=kpi_graphite_pattern.format(
        host_group="ps_front_ext", logs="balance-front-ext-real",
    ),
    crit=10000000,
    warn=10000000,
    url="https://gr-mg.yandex-team.ru",
)


def checks():
    return update_checks(
        merge(
            graphite_check(
                name="KPI_max_shipm_delay",
                metric="one_min.greedaggrprod_yandex_ru.simplebrother_balance_bo.BO.KPI_SLA.max_shipm_delay",
                crit=60,
                warn=60,
                url="https://ps-mg.yandex-team.ru",
            ),
            graphite_check(
                name="KPI_max_rcpt1c_delay",
                metric="one_min.greedaggrprod_yandex_ru.simplebrother_balance_bo.BO.KPI_SLA.max_rcpt1c_delay",
                crit=15,
                warn=15,
                url="https://ps-mg.yandex-team.ru",
            ),
            sla_int_important,
            merge(
                sla_int_day,
                sla_ext_day,
            ),
        ),
        doc(
            "https://wiki.yandex-team.ru/dljaadminov/paysys/ps/kpi-sla-monitoring/"
        ),
    )
