import itertools

from paysys.sre.tools.monitorings.configs.balance_app.base import (
    yellow_telegram,
    status_code,
    worker_idle_percent,
    servant_db_ping,
)
from paysys.sre.tools.monitorings.lib.util.helpers import merge

host = "balance.stable.medium"
children = ["balance-medium"]

cluster = "prod"
service = "medium"


def status():
    return [
        status_code.status_500(
            alert_name="500_only_status_code",
            selector_conf={
                "cluster": cluster,
                "service": service,
                "include_code": ["5*"],
                "exclude_code": ["500_timeout", "500_harakiri", "523"],
            },
            time_modifier_conf={
                "utc_start": 4,
                "utc_end": 21,
                "in_range_modifier": 20,
                "out_range_modifier": 0,
            },
            alert_conf={
                "base_limit": 19,
            },
            notification=yellow_telegram,
        ),
        status_code.status_500(
            alert_name="500_timeout_OR_harakiri_status_code",
            selector_conf={
                "cluster": cluster,
                "service": service,
                "include_code": ["500_timeout|500_harakiri"],
                "exclude_code": [],
            },
            time_modifier_conf={  # disabled
                "utc_start": 4,
                "utc_end": 21,
                "in_range_modifier": 0,
                "out_range_modifier": 0,
            },
            alert_conf={
                "base_limit": 39,
            },
            notification=yellow_telegram,
        ),
    ]


def workers_idle():
    return [
        worker_idle_percent.worker_idle(
            alert_name="total_workers_idle_percent",
            selector_conf={
                "cluster": cluster,
                "service": service,
            },
            time_modifier_conf={
                "utc_start": 4,
                "utc_end": 21,
                "in_range_modifier": 10,
                "out_range_modifier": 0,
            },
            alert_conf={
                "alarm_base": 20,
                "warn_base": 30,
            },
            notification=yellow_telegram,
        ),
    ]


def db_ping_time():
    databases = (
        "balance_1",
        "balance_2",
        "balance_ro",
        "balancedb_updatepayment",
    )

    return [
        servant_db_ping.db_ping_time(
            cluster=cluster,
            service=service,
            database_id=db,
            warn_val=15,
            crit_val=25,
        )
        for db in databases
    ]


def checks():
    return merge(
        *itertools.chain(
            status(),
            workers_idle(),
            db_ping_time(),
        )
    )
