from paysys.sre.tools.monitorings.lib.util.helpers import merge, ttl, check, unreach_skip, gen_children, flaps
from paysys.sre.tools.monitorings.lib.util.aggregators import logic_and, downtime_skip
from paysys.sre.tools.monitorings.lib.checks.base import unreachable
from paysys.sre.tools.monitorings.lib.checks.doc import mview_doc_link

host = "balance.balance-oracle"
children = ['balance-rdbms']
children_key_dbf = ['key-db1f.paysys.yandex.net', 'key-db2f.paysys.yandex.net']
children_key_dbv = ['key-db1v.paysys.yandex.net', 'key-db2v.paysys.yandex.net']
children_key_dbh = ['key-db1h.paysys.yandex.net', 'key-db2h.paysys.yandex.net']
children_all = children_key_dbf+children_key_dbv+children_key_dbh


def checks():

    balance = merge(
        check('matview-refresh', merge(ttl(3700, 300), logic_and, unreach_skip, downtime_skip, mview_doc_link())),
        check('matview-monitor', merge(ttl(3700, 300), logic_and, unreach_skip, downtime_skip, mview_doc_link())),
        check('mviewlog-usage', merge(flaps(300, 900), ttl(3700, 1800), logic_and, unreach_skip, downtime_skip, mview_doc_link())),
        check('zero-record-mviews', merge(ttl(3720, 60), flaps(600, 7200), logic_and, unreach_skip, downtime_skip, mview_doc_link())),
        check('change-master-table-balance', merge(ttl(900, 240), flaps(900, 900), logic_and, unreach_skip, downtime_skip, mview_doc_link())),

        check('seq-check', merge(ttl(3700, 300), logic_and, unreach_skip, downtime_skip, mview_doc_link())),
        check('fk-indexing', merge(ttl(3700, 300), logic_and, unreach_skip, downtime_skip, mview_doc_link())),

        check('currency-fetch', merge(ttl(900, 300), logic_and, unreach_skip, downtime_skip, mview_doc_link())),
        check('pycron_alive', merge(ttl(900, 300), logic_and, unreach_skip, downtime_skip, mview_doc_link())),
        check('oebs-export-queue', ttl(900, 300), logic_and, unreach_skip, downtime_skip, mview_doc_link()),
    )
    balance = merge(
        balance,
        *[check(key, gen_children(children_all, key, 'HOST')) for key in balance]
    )

    mvdb = merge(
        check('mvdb-services-dbf', merge(ttl(350, 60), gen_children(children_key_dbf, 'mvdb-services', 'HOST'), logic_and, unreach_skip, downtime_skip)),
        check('mvdb-services-dbv', merge(ttl(350, 60), gen_children(children_key_dbv, 'mvdb-services', 'HOST'), logic_and, unreach_skip, downtime_skip)),
        check('mvdb-services-dbh', merge(ttl(350, 60), gen_children(children_key_dbh, 'mvdb-services', 'HOST'), logic_and, unreach_skip, downtime_skip)),
        check('mvdb-services', merge(flaps(300, 7200), gen_children(host, ['mvdb-services-dbf', 'mvdb-services-dbv', 'mvdb-services-dbh'], 'HOST'),
                                     mview_doc_link())),

        check('matview-refresh-mvdb-dbf', merge(ttl(350, 60), gen_children(children_key_dbf, 'matview-refresh-mvdb', 'HOST'), logic_and, unreach_skip, downtime_skip)),
        check('matview-refresh-mvdb-dbv', merge(ttl(350, 60), gen_children(children_key_dbv, 'matview-refresh-mvdb', 'HOST'), logic_and, unreach_skip, downtime_skip)),
        check('matview-refresh-mvdb-dbh', merge(ttl(350, 60), gen_children(children_key_dbh, 'matview-refresh-mvdb', 'HOST'), logic_and, unreach_skip, downtime_skip)),
        check('matview-refresh-mvdb', merge(flaps(300, 7200), gen_children(host, ['matview-refresh-mvdb-dbf', 'matview-refresh-mvdb-dbv', 'matview-refresh-mvdb-dbh'], 'HOST'),
                                            mview_doc_link())),

        check('matview-monitor-mvdb-dbf', merge(ttl(350, 60), gen_children(children_key_dbf, 'matview-monitor-mvdb', 'HOST'), logic_and, unreach_skip, downtime_skip)),
        check('matview-monitor-mvdb-dbv', merge(ttl(350, 60), gen_children(children_key_dbv, 'matview-monitor-mvdb', 'HOST'), logic_and, unreach_skip, downtime_skip)),
        check('matview-monitor-mvdb-dbh', merge(ttl(350, 60), gen_children(children_key_dbh, 'matview-monitor-mvdb', 'HOST'), logic_and, unreach_skip, downtime_skip)),
        check('matview-monitor-mvdb', merge(flaps(300, 7200), gen_children(host, ['matview-monitor-mvdb-dbf', 'matview-monitor-mvdb-dbv', 'matview-monitor-mvdb-dbh'], 'HOST'),
                                            mview_doc_link())),
    )

    unreachable_ = merge(
        unreachable,
        check('UNREACHABLE', gen_children(children_all, 'UNREACHABLE', 'HOST'))
    )

    result = merge(
        balance, mvdb, unreachable_
    )
    return result
