import itertools

from paysys.sre.tools.monitorings.configs.balance_app.base import (
    yellow_telegram,
    green_telegram,
    partner_duty_notifications_object,
    ton,
    tpt_queue,
    ng_export,
    export,
    log_tariff,
)
from paysys.sre.tools.monitorings.lib.util.helpers import merge

host = "balance.product"
children = ["balance-product"]


def export_failed():
    queue_mapping = dict(
        cash_register=1,
        email_document=1,
        auto_cashback_charge=1,
        email_message=10,
    )

    return [
        export.check(
            cluster="prod",
            queue_name=queue_name,
            alert_size=alert_size,
            notification=yellow_telegram,
        )
        for queue_name, alert_size in queue_mapping.items()
    ]


def export_ng_failed():
    alias_mapping = {
        ("contracts", "balance.export_ng.queue.LOGBROKER-CONTRACT.failed"),
        ("personal_accounts", "balance.export_ng.queue.LOGBROKER-PERSONAL-ACCOUNT.failed"),
        ("zaxi", "balance.export_ng.queue.LOGBROKER-ZAXI.failed"),
    }

    return [
        ng_export.check(
            alias=alias,
            name=name,
            alert_size=1,
            notification=green_telegram,
        )
        for alias, name in alias_mapping
    ]


def ton_checks():
    return [
        ton.max_notify_delay(
            cluster="prod",
            alert_name="ton_max_notify_delay",
            default_limit=8,
            notification=green_telegram,
        ),
        ton.queue_len(
            cluster="prod",
            alert_name="ton_queue_len",
            alarm_size=30000,
            notification=green_telegram,
        ),
    ]


def tpt_checks():
    return [
        tpt_queue.queue_size("prod", alert_size * 1000, notification_chat)
        for alert_size, notification_chat in [
            (250, green_telegram),
            (500, yellow_telegram),
            (750, yellow_telegram),
            (1000, partner_duty_notifications_object.iron_woman_daytime_and_telegram),
        ]
    ]


def partner_checks():
    tarification = log_tariff.Checks(
        host=host,
        cluster="prod",
    )
    return [
        tarification.delay(
            folder_alias="partner_bs",
            folder="log_tariff/public/expense/partner/tariffed",
            limit_sec=5 * 3600,
            notification=partner_duty_notifications_object.iron_woman_daytime_and_telegram,
        )
    ]


def checks():
    return merge(
        *itertools.chain(
            export_failed(),
            export_ng_failed(),
            ton_checks(),
            tpt_checks(),
            partner_checks(),
        )
    )
