import itertools

from paysys.sre.tools.monitorings.configs.balance_app.base import (
    yellow_telegram,
    green_telegram,
    status_code,
    worker_idle_percent,
    servant_db_ping,
)
from paysys.sre.tools.monitorings.lib.util.helpers import merge

host = "balance.stable.snout_api"
children = ["balance-snout-api"]

cluster = "prod"
service = "snout_api"


def status():
    return [
        status_code.status_500(
            alert_name="500_status_code",
            selector_conf={
                "service": service,
                "cluster": cluster,
                "include_code": ["5*"],
                "exclude_code": ["500_harakiri", "523"],
            },
            time_modifier_conf={
                "utc_start": 4,
                "utc_end": 21,
                "in_range_modifier": 200,
                "out_range_modifier": 0,
            },
            alert_conf={
                "base_limit": 10,
            },
            notification=green_telegram,
        ),
    ]


def workers_idle():
    return [
        worker_idle_percent.worker_idle(
            alert_name="total_workers_idle_percent",
            selector_conf={
                "cluster": cluster,
                "service": service,
            },
            time_modifier_conf={
                "utc_start": 4,
                "utc_end": 21,
                "in_range_modifier": 0,
                "out_range_modifier": 0,
            },
            alert_conf={
                "alarm_base": 60,
                "warn_base": 70,
            },
            notification=yellow_telegram,
        ),
    ]


def db_ping_time():
    databases = ("balance_2", "balance_ro", "meta")

    return [
        servant_db_ping.db_ping_time(
            cluster=cluster,
            service=service,
            database_id=db,
            warn_val=15,
            crit_val=25,
        )
        for db in databases
    ]


def checks():
    return merge(
        *itertools.chain(
            status(),
            workers_idle(),
            db_ping_time(),
        )
    )
