from paysys.sre.tools.monitorings.configs.balance_app.base import (
    mnclose_notifications,
    queue_status,
)
from paysys.sre.tools.monitorings.lib.util.helpers import (
    merge,
    empty_children,
    get_annotation,
)

CLUSTER = 'prod'
DEFAULT_ALERT_SIZE = 1
WINDOW_SECS = 5 * 60

host = "balance.monthclose.queue_status"
children = empty_children

queue_mapping = {
    'MONTH_PROC': ('*', 'queue-processor'),
    'PARTNER_ACTS': ('*', 'queue-processor'),
    'UA_TRANSFER': ('*', 'queue-processor'),
    'AUTO_OVERDRAFT': ('*', 'queue-processor'),
    'OEBS_API': ('Act', 'oebs-api'),
    # 'OEBS': ('Product', 'oebs)'
}

annotation_text = 'At least one object in t_export has status fail or too_many_retries'
alert_annotation = get_annotation(annotation_text)

alerts = []
for queue, data in queue_mapping.iteritems():
    classname, service = data
    alert_name = '{queue}-export_problem'.format(queue=queue)
    alerts.append(
        queue_status.check(
            alert_name=alert_name,
            alert_annotation=alert_annotation,
            selector_conf={
                "cluster": CLUSTER,
                "service": service,
                "classname": classname,
                "queue": queue,
            },
            alert_conf={"alarm_size": DEFAULT_ALERT_SIZE},
            notification=mnclose_notifications,
            window_secs=WINDOW_SECS,
        )
    )


def checks():
    return merge(*alerts)
