from paysys.sre.tools.monitorings.lib.util.helpers import empty_children, merge
from paysys.sre.tools.monitorings.lib.checks.yt import Checks as YtChecks

host = "balance.yt"

children = empty_children


def checks():
    yt = YtChecks(
        solomon_project_id="balance",
        host=host,
        clusters_list=['hahn', 'arnold', 'vanga', 'freud']
    )

    return merge(
        yt.account_bundle(account_list=['balance_reports', 'dwh']),
        yt.account_bundle(
            account_list=['balance'],
            crit_threshold_percent=95,
            warn_threshold_percent=90,
            alert_suffix='_high_quota',
        )
    )
