from paysys.sre.tools.monitorings.lib.util.solomon import solomon_expression_custom
from paysys.sre.tools.monitorings.lib.util.helpers import (
    merge,
    solomon_check,
    solomon_equal_selector,
    join_solomon_program_code,
    empty_children,
    get_annotation,
)

alert_project = 'balance'
host = "{}.stable.yt_export".format(alert_project)
children = empty_children

recency_text = 'Table "yt_export_dwh_paysup_contracts" has not been updated for {{expression.hours}} hours.'

row_count_text = 'Total row count for table "yt_export_dwh_paysup_contracts": {{expression.diff}} is below than 1 day ago!'


def _get_selector(sensor):
    return solomon_equal_selector(
        project="balance-reports", cluster="Push", service="YbReports", mview="paysup_contracts", sensor=sensor
    )


recency_program_str = join_solomon_program_code(
    'let data = {}'.format(_get_selector('recency')),
    'let last_point = last(data)',
    'let alarm_threshold_hours = 48',
    'let hours = last_point / 60 / 60',
    'alarm_if(hours > alarm_threshold_hours)',
)

rows_count_diff_program_str = join_solomon_program_code(
    'let past_data = shift({}, 1d)'.format(_get_selector('rows')),
    'let data = {}'.format(_get_selector('rows')),
    'let diff = last(past_data) - last(data)',
    'alarm_if(diff > 0)',
)


def _get_check(alert_name, program_str, description, annotations):
    expr = solomon_expression_custom(
        program_str=program_str,
        project_id=alert_project,
        annotations=annotations,
        description=description,
        window_secs=30 * 60,
    )
    return solomon_check(
        alert_name,
        expr,
        {"aggregator_kwargs": None},
    )


def checks():
    return merge(
        _get_check(
            'paysup-contracts-recency',
            recency_program_str,
            "Recency",
            get_annotation(recency_text),
        ),
        _get_check(
            'paysup-contracts-row-count',
            rows_count_diff_program_str,
            "Row count difference 1d ago and now",
            get_annotation(row_count_text),
        ),
    )
