# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from paysys.sre.tools.monitorings.configs.mdh.common import ProjectConfig, Component


class BclComponent(Component):

    balancer_service = 'rtc_balancer_{prjalt[-env]}-l7_paysys_yandex_net'

    def apply_env(self, env, context_base):
        super(BclComponent, self).apply_env(env, context_base)
        # в деплое используется краткое имя проекта (bcl)
        # и иное наименование для боевого стенда
        self.deploy_group = self.deploy_group.replace('prod-', 'production-')

        # В бою используется host balalayka.yandex-team.ru, а не balalayka.paysys.yandex-team.ru
        self.fqdn = self.fqdn.replace('balalayka.paysys', 'balalayka')


class BclConfig(ProjectConfig):

    project = 'bcl'
    project_alt = 'balalayka'

    components = [
        BclComponent(
            alias='backend',
            fqdn='{prjalt[-env]}.{dom_paysys_yteam}',
            port=8015,
        ),
        BclComponent(
            alias='callbacks',
            fqdn='{prj}-callback{[-env]}.{dom_paysys}',
            deploy_group='{prj}@stage={prj-env}-stage;deploy_unit=backend',
            port=8015,
            ports_balancer=([], [8443]),
        ),
    ]

    check_graphite = True
