from paysys.sre.tools.monitorings.lib.util.aggregators import logic_or
from paysys.sre.tools.monitorings.lib.util.helpers import merge, check, ttl, gen_children
from paysys.sre.tools.monitorings.lib.notifications import (
    FIN_TOOLS_ESCALATION_USERS,
    FIN_TOOLS_TELEGRAM_GROUP,
)

from paysys.sre.tools.monitorings.configs.mdh.common import Production
from paysys.sre.tools.monitorings.configs.bcl.base import bcl

cfg = bcl.BclConfig(env=Production(
    notify_iron=FIN_TOOLS_ESCALATION_USERS,
    notify_telegram=FIN_TOOLS_TELEGRAM_GROUP,
))

host = cfg.host_alias
namespace = cfg.project
children = cfg.children_all


def checks():
    return merge(
        cfg.get_checks(pg_cluster='3393c528-8be4-4315-a088-38e0fd43d9a6'),
        _get_dt_lag()
    )


def _get_dt_lag():
    """
        Проверка на лаг репликации ДатаТрансфера
        https://yc.yandex-team.ru/folders/foo62lpsqp5bbadt5m7g/data-transfer/transfer/dtth2st398lf4th0836b
    """
    dt_lag = check('data-transfer-export-lag', merge(ttl(240, 90), logic_or,
                                                     gen_children(['dtth2st398lf4th0836b'],
                                                                  'dta_04_row_max_lag_constant',
                                                                  'HOST')))
    checks = merge(
        dt_lag,
    )
    for key, val in checks.items():
        val["aggregator_kwargs"] = merge(val.get("aggregator_kwargs", {}), {"nodata_mode": "force_crit"})
    return checks
