from paysys.sre.tools.monitorings.lib.util.helpers import merge, ttl, flaps, check, gen_children
from paysys.sre.tools.monitorings.lib.checks import base, services
from paysys.sre.tools.monitorings.lib.checks.active.http import https
from paysys.sre.tools.monitorings.lib.util.aggregators import logic_and


def get_checks(children):
    checks = merge(
        base.common_fin_fin(children),
        base.iptunnels,
        services.check_slb,
        services.gluster_health,
        services.haproxy,
        services.jmx2graphite,
        services.keepalived,
        services.ldap,
        services.mailq,
        services.nginx,
        services.stunnel,
        {'bi_rsync': ttl(1200, 600)},
        {'sendmail': merge(ttl(1800, 1200), flaps(1800, 0))},
        {'sso': merge(ttl(1800, 300), flaps(1200, 0))},
        {'dc_closer_slb_status': merge(ttl(360, 120), logic_and)},
        check('dc_closer_config', ttl(900, 600), gen_children(
            children, ['dc_closer_config', 'dc_closer_secret'])),
        check('dc_closer_health', merge(ttl(360, 120), flaps(240, 0)), gen_children(
            children, [
                'dc_closer_service',
                'dc_closer_socket',
                'dc_closer_status_file_expired'
            ])),
        check('integration', ttl(600, 300), gen_children(children, 'integration_xml_config_is_valid')),
        check('keystores', ttl(900, 300), gen_children(children, ['bi_pfx', 'truststore_jks'])),
        check('mstr_coredumps', ttl(1200, 450), gen_children(children, 'intelligence_server_coredumps')),
        check('mstr_config', ttl(600, 300), gen_children(
            children, [
                'mstr_web_session_timeout_configuration',
                'mstr_web_sys_defaults_properties',
                'mstr_web_sys_defaults_server_properties',
                'mstr_web_version',
                'intelligence_server_version',
                'mstr_ldaps_referrals',
                'mstr_library_config_override_properties',
                'mstr_library_session_timeout_configuration'
            ])),
        check('mstr_health', ttl(600, 300), flaps(600, 0), gen_children(
            children, [
                'mstr',
                'pdf_export_service',
                'intelligence_server_pdf_export_service',
                'intelligence_server_port_is_listened',
                'intelligence_server_process_is_running'
            ])),
        check('mstr_web', ttl(600, 300), flaps(600, 0), gen_children(
            children, [
                'mstr_web_running_projects',
                'mstr_web_connected_intelligent_servers'
            ])),
        check('mstr_aux', ttl(3600, 1800), gen_children(
            children, [
                'mstr_aux_empty_dirs_count',
                'mstr_aux_move_empty_dirs_status'
            ])),
        check('tomcat_config', ttl(600, 300), gen_children(
            children, [
                'tomcat_cluster_configuration',
                'tomcat_access_log_configuration',
                'tomcat_delta_manager_configuration',
                'tomcat_directories_exist',
                'tomcat_jvm_paramteres_of_running_process',
                'tomcat_resource_caching_configuration',
                'tomcat_session_timeout_configuration'
            ])),
        check('tomcat_health', ttl(600, 300), gen_children(
            children, ['tomcat_port_is_listened', 'tomcat_process_is_running'])),
        https('idm_status', path='/idm-status'),
        https('mstr_library', path='/MicroStrategyLibrary/api/status'),
        check('tvm_health', ttl(600, 300), gen_children(
            children, [
                'tvm_ping'
            ]
        )),
        check('beegfs_health', ttl(240, 120), flaps(60, 0), gen_children(
            children, [
                'beegfs-client-checks',
                'beegfs-client-mount',
                'beegfs-client-service',
                'beegfs-meta-service',
                'beegfs-meta-state',
                'beegfs-storage-service',
                'beegfs-storage-state'
            ])),
        check('beegfs_mgmt', ttl(240, 120), logic_and, gen_children(
            children, [
                'beegfs-mgmtd-service',
                'beegfs-mgmtd-mountpoint-rw',
                'beegfs-mgmtd-mountpoint-rw-status'
            ])),
        check('beegfs_config', ttl(240, 120), flaps(120, 0), gen_children(
            children, [
                'beegfs-confgen',
                'beegfs-mgmtd-route',
                'beegfs-meta-role',
                'beegfs-storage-role'
            ]))
    )

    checks.pop('ldap-limits')

    return checks
