from paysys.sre.tools.monitorings.configs.bi.base import db

from paysys.sre.tools.monitorings.lib.util.helpers import merge, ttl, gen_children, check, unreach_skip, flaps, gen_unreach_by_service
from paysys.sre.tools.monitorings.lib.util.aggregators import downtime_skip, logic_and, logic_or
from paysys.sre.tools.monitorings.lib.checks.graphite import graphite_check


host = "bi.stable.db"
children = ['bi_prod_db']


def checks():
    first_nodes_children = gen_children(
        [
            'bi-db01h.oebs.yandex.net',
            'bi-db01f.oebs.yandex.net',
            'bi-db01v.oebs.yandex.net'
        ],
        'oracle-status-BI1', 'HOST'
    )

    second_nodes_children = gen_children(
        [
            'bi-db02h.oebs.yandex.net',
            'bi-db02f.oebs.yandex.net',
            'bi-db02v.oebs.yandex.net'
        ],
        'oracle-status-BI2', 'HOST'
    )

    checks = merge(
        db.get_checks(children),
        check('oracle-status-BI1', merge(first_nodes_children, logic_and, flaps(900, 0))),
        check('oracle-status-BI2', merge(second_nodes_children, logic_and, flaps(900, 0))),
        check('ro-services-bi', gen_children(children, 'ro-services')),
        graphite_check('diskstat_wait_sas', 'movingAverage(averageSeries(one_min.{bi-db01h_oebs_yandex_net,bi-db02h_oebs_yandex_net}.diskstat_wait*.wait),20)', window='-60min', crit_expr='metric > 50'),  # noqa
        graphite_check('diskstat_wait_myt', 'movingAverage(averageSeries(one_min.{bi-db01f_oebs_yandex_net,bi-db02f_oebs_yandex_net}.diskstat_wait*.wait),20)', window='-60min', crit_expr='metric > 50'),  # noqa
        graphite_check('diskstat_wait_vla', 'movingAverage(averageSeries(one_min.{bi-db01v_oebs_yandex_net,bi-db02v_oebs_yandex_net}.diskstat_wait*.wait),20)', window='-60min', crit_expr='metric > 50'),  # noqa
        graphite_check('number_of_degraded_disks_sas', 'countSeries(maximumAbove(one_min.bi-db01h_oebs_yandex_net.diskstat_wait*.wait,300))', window='-5min', crit_expr='metric > 0', null_status='OK'),  # noqa
        graphite_check('number_of_degraded_disks_myt', 'countSeries(maximumAbove(one_min.bi-db01f_oebs_yandex_net.diskstat_wait*.wait,300))', window='-5min', crit_expr='metric > 0', null_status='OK'),  # noqa
        graphite_check('number_of_degraded_disks_vla', 'countSeries(maximumAbove(one_min.bi-db01v_oebs_yandex_net.diskstat_wait*.wait,300))', window='-5min', crit_expr='metric > 0', null_status='OK'),  # noqa
        check('uptime', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'uptime'),
                              logic_or, unreach_skip, downtime_skip)),
        check('grid-up', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'grid-up'),
                               logic_or, unreach_skip, downtime_skip)),
        check('database-up', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'database-up'),
                                   logic_or, unreach_skip, downtime_skip)),
        check('unispace5', merge(flaps(300, 900), ttl(620, 300), gen_children(children, 'unispace5'),
                                 logic_or, unreach_skip, downtime_skip)),
        check('s3backup-bi', merge(flaps(300, 900), ttl(3700, 1800), logic_or, unreach_skip, downtime_skip)),
    )

    checks.pop('matview-monitor')
    checks.pop('matview-refresh')
    checks.pop('oracle-status')

    checks = gen_unreach_by_service(checks)
    return checks
